/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration;

import com.boozallen.aissemble.upgrade.migration.AbstractAissembleMigration;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.util.CommonUtils;
import org.technologybrewery.baton.util.FileUtils;

public class HelmChartsV1Migration
extends AbstractAissembleMigration {
    public static final Logger logger = LoggerFactory.getLogger(HelmChartsV1Migration.class);
    private static final String versionReplaceRegex = "(tag: *)\\\"?\\d+\\.\\d+\\.\\d+(?:[a-zA-Z-\\d+]*)\\\"?";
    public static final String extractVersionRegex = "tag: *\"?(\\d+\\.\\d+\\.\\d+[-a-zA-Z\\.\\d+]*)\"?";
    private String mavenAissembleVersion;

    @Override
    protected boolean shouldExecuteOnFile(File file) {
        boolean shouldExecute = false;
        if (file != null && file.exists()) {
            try {
                this.mavenAissembleVersion = this.getAissembleVersion();
                if (this.mavenAissembleVersion != null) {
                    List chartAissembleVersions = FileUtils.getRegExCaptureGroups((String)extractVersionRegex, (File)file);
                    if (!chartAissembleVersions.isEmpty()) {
                        shouldExecute = chartAissembleVersions.stream().anyMatch(chartVersion -> CommonUtils.isLessThanVersion((String)chartVersion, (String)this.mavenAissembleVersion));
                    }
                } else {
                    logger.error("Unable to parse version from current project");
                }
            }
            catch (IOException e) {
                logger.error("Unable to load file into yaml class due to exception:", (Throwable)e);
            }
        }
        return shouldExecute;
    }

    @Override
    protected boolean performMigration(File file) {
        boolean performedSuccessfully = false;
        try {
            String replacementText = "$1".concat("\"" + this.mavenAissembleVersion + "\"");
            performedSuccessfully = FileUtils.replaceInFile((File)file, (String)versionReplaceRegex, (String)replacementText);
        }
        catch (Exception e) {
            logger.error("Unable to perform v1 helm charts migration due to exception", (Throwable)e);
        }
        return performedSuccessfully;
    }
}

