/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration;

import com.boozallen.aissemble.upgrade.migration.AbstractAissembleMigration;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.util.CommonUtils;
import org.technologybrewery.baton.util.FileUtils;
import org.yaml.snakeyaml.Yaml;

public class HelmChartsV2Migration
extends AbstractAissembleMigration {
    public static final Logger logger = LoggerFactory.getLogger(HelmChartsV2Migration.class);
    public static final String VERSION_APP_VERSION_REPLACE_REGEX = "([\\t -]+ (?:version|appVersion): *)(.*)";
    private HashMap<String, Object> yamlMap;
    private InputStream fileStream;
    private String mavenAissembleVersion;

    @Override
    protected boolean shouldExecuteOnFile(File file) {
        Yaml helmChartYaml = new Yaml();
        boolean shouldExecute = false;
        if (file != null && file.exists()) {
            try {
                this.fileStream = Files.asByteSource((File)file).openStream();
                this.yamlMap = (HashMap)helmChartYaml.load(this.fileStream);
                if (HelmChartsV2Migration.isAissembleChartFile(this.yamlMap)) {
                    this.mavenAissembleVersion = this.getAissembleVersion();
                    String apiVersion = (String)this.yamlMap.get("apiVersion");
                    if (this.mavenAissembleVersion != null && StringUtils.equals((CharSequence)apiVersion, (CharSequence)"v2")) {
                        List dependencies = (List)this.yamlMap.get("dependencies");
                        if (dependencies != null) {
                            shouldExecute = dependencies.stream().anyMatch(dependency -> {
                                Object chartAissembleVersion = dependency.get("version");
                                if (chartAissembleVersion instanceof String) {
                                    return CommonUtils.isLessThanVersion((String)((String)chartAissembleVersion), (String)this.mavenAissembleVersion);
                                }
                                return false;
                            });
                        }
                    } else {
                        logger.error("Unable to parse version from current project");
                    }
                }
            }
            catch (IOException e) {
                logger.error("Unable to load file into yaml class due to exception:", (Throwable)e);
            }
        }
        if (shouldExecute) {
            logger.info("Found v2 Helm Chart with dependencies that are upgrade candidates");
        }
        return shouldExecute;
    }

    @Override
    protected boolean performMigration(File file) {
        boolean performedSuccessfully = false;
        ArrayList<String> newFileContents = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            boolean startChangingVersions = false;
            boolean lastNameWasAissemble = false;
            while ((line = reader.readLine()) != null) {
                if (!(startChangingVersions = HelmChartsV2Migration.disableIfNotDependencyProperty(startChangingVersions, line)) && line.contains("dependencies:")) {
                    startChangingVersions = true;
                }
                if (startChangingVersions && line.contains("name:")) {
                    lastNameWasAissemble = line.contains("aissemble-");
                }
                String newLine = startChangingVersions && lastNameWasAissemble && line.matches(VERSION_APP_VERSION_REPLACE_REGEX) ? this.upgradeVersionInString(line) : StringUtils.appendIfMissing((String)line, (CharSequence)"\n", (CharSequence[])new CharSequence[0]);
                newFileContents.add(newLine);
            }
            HelmChartsV2Migration.writeNewFile(file, newFileContents);
            performedSuccessfully = true;
        }
        catch (Exception e) {
            logger.error("Unable to perform helm chart v2 migration", (Throwable)e);
        }
        return performedSuccessfully;
    }

    private static void writeNewFile(File file, ArrayList<String> newFileContents) throws IOException {
        FileOutputStream fileStream = new FileOutputStream(file);
        for (String content : newFileContents) {
            ((OutputStream)fileStream).write(content.getBytes(StandardCharsets.UTF_8));
        }
        fileStream.flush();
        ((OutputStream)fileStream).close();
    }

    private String upgradeVersionInString(String line) {
        List captureGroups = FileUtils.getRegExCaptureGroups((String)VERSION_APP_VERSION_REPLACE_REGEX, (String)line);
        String currentVersion = this.getAissembleVersion();
        String oldVersion = ((String)captureGroups.get(1)).replaceAll("['|\"]", "").trim();
        String newVersion = CommonUtils.isLessThanVersion((String)oldVersion, (String)currentVersion) ? currentVersion : oldVersion;
        String newLine = (String)captureGroups.get(0) + "\"" + newVersion + "\"";
        return StringUtils.appendIfMissing((String)newLine, (CharSequence)"\n", (CharSequence[])new CharSequence[0]);
    }

    private static boolean disableIfNotDependencyProperty(boolean startChangingVersions, String line) {
        if (!(!startChangingVersions || line.startsWith(" ") || line.startsWith("\t") || line.startsWith("-") || line.startsWith("#"))) {
            startChangingVersions = false;
        }
        return startChangingVersions;
    }

    private static boolean isAissembleChartFile(HashMap<String, Object> map) {
        Object yamlName = map.get("name");
        return yamlName instanceof String;
    }
}

