/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration;

import com.boozallen.aissemble.upgrade.migration.AbstractAissembleMigration;
import com.boozallen.aissemble.upgrade.util.TiltfileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.util.CommonUtils;
import org.technologybrewery.baton.util.FileUtils;

public class TiltfileMigration
extends AbstractAissembleMigration {
    public static final String VERSION_REGEX = "(aissemble_version = *['\"])(\\d+\\.\\d+\\.\\d+(?:[\\.\\-\\d+a-zA-Z]*))(['\"])";
    public static final Logger logger = LoggerFactory.getLogger(TiltfileMigration.class);

    @Override
    public boolean shouldExecuteOnFile(File file) {
        boolean foundNewAissembleVersion = false;
        boolean shouldExecute = false;
        try (BufferedReader tiltFileConfig = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = tiltFileConfig.readLine()) != null) {
                String tiltfileVersionvalue;
                if (line.contains("aissemble_version")) {
                    foundNewAissembleVersion = true;
                }
                if ((tiltfileVersionvalue = TiltfileUtil.extractAissembleVersion(line)) == null || !CommonUtils.isLessThanVersion((String)tiltfileVersionvalue, (String)this.getAissembleVersion())) continue;
                logger.info("Found VERSION_AISSEMBLE that is less than project aiSSEMBLE version in the Tiltfile.");
                shouldExecute = true;
            }
        }
        catch (IOException e) {
            logger.error("Unable to load file.", (Throwable)e);
        }
        return shouldExecute && foundNewAissembleVersion;
    }

    @Override
    public boolean performMigration(File file) {
        boolean isMigrated = false;
        try (BufferedReader tiltFileConfig = new BufferedReader(new FileReader(file));){
            String substitution = "$1" + this.getAissembleVersion() + "$3";
            isMigrated = FileUtils.replaceInFile((File)file, (String)"(aissemble_version *= *['\"])(\\d+.\\d+.\\d+[-\\da-zA-Z]*)(['\"])", (String)substitution);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return isMigrated;
    }
}

