/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration.v1_10_0;

import com.boozallen.aissemble.upgrade.migration.AbstractAissembleMigration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertingCdiMigration
extends AbstractAissembleMigration {
    public static final Logger logger = LoggerFactory.getLogger(AlertingCdiMigration.class);
    public static final String GROUP = "com.boozallen.aissemble";
    public static final String CDI_CLASS = "AlertingCdiContext";
    public static final String FQCN = "com.boozallen.aissemble.alerting.core.cdi.AlertingCdiContext";

    @Override
    protected boolean shouldExecuteOnFile(File file) {
        return "CdiContainerFactory.java".equals(file.getName()) && this.dependsOnAlerting() && !this.addsAlerting(file);
    }

    @Override
    protected boolean performMigration(File file) {
        String knownContext = "PipelinesCdiContext";
        Pattern contextAddPattern = Pattern.compile(".*?\\.add\\(\\s*new " + knownContext + "\\(\\)\\s*\\);");
        File tempFile = new File(file.getParent(), file.getName() + ".tmp");
        boolean addedImport = false;
        boolean addedContext = false;
        try (BufferedReader reader = Files.newBufferedReader(file.toPath());
             BufferedWriter writer = Files.newBufferedWriter(tempFile.toPath(), new OpenOption[0]);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!addedImport && line.startsWith("import com.boozallen.aissemble")) {
                    writer.write("import com.boozallen.aissemble.alerting.core.cdi.AlertingCdiContext;");
                    writer.newLine();
                    addedImport = true;
                } else if (addedImport && !addedContext && contextAddPattern.matcher(line).matches()) {
                    writer.write(line.replace(knownContext, CDI_CLASS));
                    writer.newLine();
                    addedContext = true;
                }
                writer.write(line);
                writer.newLine();
            }
            Files.move(tempFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update CdiContainerFactory with AlertingCdiContext", e);
        }
        if (!addedImport) {
            logger.warn("Could not detect import injection point for com.boozallen.aissemble.alerting.core.cdi.AlertingCdiContext");
            logger.warn("Migration failed for " + file.getPath());
        } else if (!addedContext) {
            logger.warn("Could not detect context list injection point for AlertingCdiContext");
            logger.warn("Migration partially failed for " + file.getPath());
        }
        return addedContext;
    }

    private boolean addsAlerting(File file) {
        boolean imported = false;
        boolean constructed = false;
        try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("import com.boozallen.aissemble.alerting.core.cdi.AlertingCdiContext")) {
                    imported = true;
                    continue;
                }
                if (line.contains("new com.boozallen.aissemble.alerting.core.cdi.AlertingCdiContext")) {
                    constructed = true;
                    continue;
                }
                if (!imported || !line.contains("new AlertingCdiContext")) continue;
                constructed = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to inspect CdiContainerFactory class contents to determine if migration is needed", e);
        }
        return constructed;
    }

    private boolean dependsOnAlerting() {
        return this.getMavenProject().getDependencies().stream().anyMatch(this::isAlerting);
    }

    private boolean isAlerting(Dependency dependency) {
        return GROUP.equals(dependency.getGroupId()) && "foundation-alerting".equals(dependency.getArtifactId());
    }
}

