/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration.v1_10_0;

import com.boozallen.aissemble.upgrade.migration.AbstractPomMigration;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Model;
import org.technologybrewery.baton.BatonException;
import org.technologybrewery.baton.util.FileUtils;
import org.technologybrewery.baton.util.pom.LocationAwareMavenReader;
import org.technologybrewery.baton.util.pom.PomHelper;
import org.technologybrewery.baton.util.pom.PomModifications;

public class DeltaSparkPomMigration
extends AbstractPomMigration {
    public static final String ARTIFACT_ID = "artifactId";
    public static final String DELTA_VERSION = "${version.delta}";

    @Override
    protected boolean shouldExecuteOnFile(File file) {
        try {
            return FileUtils.hasRegExMatch((String)"<artifactId>[\\n\\s]*delta-core_2.1[23][\\n\\s]*</artifactId>", (File)file);
        }
        catch (IOException e) {
            throw new BatonException("Could not check file for DeltaLake dependencies: " + file.getPath(), (Throwable)e);
        }
    }

    @Override
    protected boolean performMigration(File file) {
        Model model = PomHelper.getLocationAnnotatedModel((File)file);
        List<Dependency> deltaCoreDependencies = this.getMatchingDependenciesForProject(model, DeltaSparkPomMigration::isDeltaCore);
        PomModifications modifications = new PomModifications();
        for (Dependency dependency : deltaCoreDependencies) {
            String artifactId = dependency.getArtifactId();
            String newArtifact = artifactId.replace("core", "spark");
            modifications.add((Object)DeltaSparkPomMigration.replaceInTag((InputLocationTracker)dependency, ARTIFACT_ID, newArtifact));
            if (dependency.getLocation((Object)"version") != null) {
                modifications.add((Object)DeltaSparkPomMigration.replaceInTag((InputLocationTracker)dependency, "version", DELTA_VERSION));
                continue;
            }
            int indentSize = dependency.getLocation((Object)(ARTIFACT_ID + LocationAwareMavenReader.START)).getColumnNumber() - 1;
            String indent = StringUtils.repeat((char)' ', (int)indentSize);
            modifications.add((Object)new PomModifications.Insertion(dependency.getLocation((Object)LocationAwareMavenReader.END), 0, ignore -> indent + "<version>${version.delta}</version>\n"));
        }
        if (!modifications.isEmpty()) {
            PomHelper.writeModifications((File)file, (PomModifications.Final)modifications.finalizeMods());
        }
        return true;
    }

    private static boolean isDeltaCore(Dependency dep) {
        return dep.getGroupId().equals("io.delta") && dep.getArtifactId().startsWith("delta-core_");
    }
}

