/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration.v1_10_0;

import com.boozallen.aissemble.upgrade.migration.AbstractAissembleMigration;
import com.boozallen.aissemble.upgrade.util.YamlUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.BatonException;
import org.yaml.snakeyaml.error.YAMLException;

public class DeltaSparkYamlMigration
extends AbstractAissembleMigration {
    private static final Logger logger = LoggerFactory.getLogger(DeltaSparkYamlMigration.class);

    @Override
    protected boolean shouldExecuteOnFile(File file) {
        if (file.getName().endsWith(".yaml")) {
            try {
                YamlUtils.YamlObject yaml = YamlUtils.loadYaml(file);
                if (yaml.hasObject("sparkApp")) {
                    yaml = yaml.getObject("sparkApp");
                }
                if (yaml.hasList("spec", "deps", "packages")) {
                    List<String> pkgs = yaml.getListOfStrings("spec", "deps", "packages");
                    return pkgs.stream().anyMatch(pkg -> pkg.startsWith("io.delta:"));
                }
            }
            catch (YAMLException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to parse YAML file, likely because it is a Helm template: {}", (Object)file.getPath(), (Object)e);
                } else {
                    logger.info("Failed to parse YAML file, likely because it is a Helm template: {}", (Object)file.getName());
                }
            }
            catch (IOException e) {
                throw new BatonException("Failed to read YAML file.", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    protected boolean performMigration(File file) {
        try {
            List<String> lines = Files.readAllLines(file.toPath());
            boolean inPackages = false;
            boolean update = false;
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i).trim();
                if (inPackages) {
                    if (line.startsWith("-")) {
                        update = DeltaSparkYamlMigration.updatePackageIfNecessary(lines, i);
                    } else {
                        inPackages = false;
                    }
                }
                if (inPackages || !"packages:".equals(line)) continue;
                inPackages = true;
            }
            if (update) {
                Files.write(file.toPath(), lines, new OpenOption[0]);
            }
            return true;
        }
        catch (IOException e) {
            throw new BatonException("Failed to update Delta Lake Spark jars in: " + file.getPath(), (Throwable)e);
        }
    }

    private static boolean updatePackageIfNecessary(List<String> lines, int i) {
        boolean updatesMade = false;
        String line = lines.get(i);
        if (line.contains(" io.delta:delta-core")) {
            String updated = line.replaceFirst("\\bio\\.delta:delta-core_(.*?):\\S+(.*)", "io.delta:delta-spark_$1:3.2.1$2");
            lines.set(i, updated);
            updatesMade = true;
        } else if (line.contains(" io.delta:delta-storage")) {
            String updated = line.replaceFirst("\\bio\\.delta:delta-storage:(?!3\\.2\\.1\\b)\\S+(.*)", "io.delta:delta-storage:3.2.1$1");
            lines.set(i, updated);
            updatesMade = true;
        } else if (line.matches("\\bio\\.delta:.*?:[012]\\..*")) {
            logger.warn("Delta Lake package not updated. Consider upgrading to 3.2.1: " + line);
        }
        return updatesMade;
    }
}

