/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration.v1_10_0;

import com.boozallen.aissemble.upgrade.migration.AbstractAissembleMigration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.BatonException;

public class JavaPackageMigration
extends AbstractAissembleMigration {
    private static final Logger logger = LoggerFactory.getLogger(JavaPackageMigration.class);
    private static final Map<String, String> JAVA_PACKAGES = Map.ofEntries(Map.entry("javax.activation", "jakarta.activation"), Map.entry("javax.annotation", "jakarta.annotation"), Map.entry("javax.batch", "jakarta.batch"), Map.entry("javax.data", "jakarta.data"), Map.entry("javax.decorator", "jakarta.decorator"), Map.entry("javax.ejb", "jakarta.ejb"), Map.entry("javax.el", "jakarta.el"), Map.entry("javax.enterprise", "jakarta.enterprise"), Map.entry("javax.faces", "jakarta.faces"), Map.entry("javax.inject", "jakarta.inject"), Map.entry("javax.interceptor", "jakarta.interceptor"), Map.entry("javax.jms", "jakarta.jms"), Map.entry("javax.json", "jakarta.json"), Map.entry("javax.mail", "jakarta.mail"), Map.entry("javax.persistence", "jakarta.persistence"), Map.entry("javax.resource", "jakarta.resource"), Map.entry("javax.security", "jakarta.security"), Map.entry("javax.servlet", "jakarta.servlet"), Map.entry("javax.transaction", "jakarta.transaction"), Map.entry("javax.validation", "jakarta.validation"), Map.entry("javax.websocket", "jakarta.websocket"), Map.entry("javax.ws", "jakarta.ws"), Map.entry("io.smallrye.reactive.messaging.providers.connectors.InMemoryConnector", "io.smallrye.reactive.messaging.memory.InMemoryConnector"), Map.entry("io.smallrye.reactive.messaging.providers.connectors.InMemorySink", "io.smallrye.reactive.messaging.memory.InMemorySink"));

    @Override
    protected boolean shouldExecuteOnFile(File file) {
        try {
            String fileContent = Files.readString(file.toPath());
            return JAVA_PACKAGES.keySet().stream().anyMatch(packageName -> fileContent.contains((CharSequence)packageName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean performMigration(File file) {
        logger.info("Migrating file to update java class packages: {}", (Object)file.getAbsolutePath());
        try {
            String fileContent = Files.readString(file.toPath());
            for (Map.Entry<String, String> packageEntry : JAVA_PACKAGES.entrySet()) {
                fileContent = fileContent.replace(packageEntry.getKey(), packageEntry.getValue());
            }
            Files.writeString(file.toPath(), (CharSequence)fileContent, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            throw new BatonException("Failed to update Java file with new class package", (Throwable)e);
        }
    }
}

