/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration.v1_10_0;

import com.boozallen.aissemble.upgrade.migration.AbstractPomMigration;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.util.pom.LocationAwareMavenReader;
import org.technologybrewery.baton.util.pom.PomHelper;
import org.technologybrewery.baton.util.pom.PomModifications;

public class PomDependencyVersionMigration
extends AbstractPomMigration {
    private static final Logger logger = LoggerFactory.getLogger(PomDependencyVersionMigration.class);
    private static final List<Dependency> DEPENDENCIES_TO_UPDATE = Arrays.asList(PomDependencyVersionMigration.dependency("com.amazonaws", "aws-java-sdk-bundle", "${version.aws.sdk.bundle}"), PomDependencyVersionMigration.dependency("io.delta", "", "${version.delta}"), PomDependencyVersionMigration.dependency("io.smallrye.config", "smallrye-config", "${version.smallrye.config}"), PomDependencyVersionMigration.dependency("io.smallrye.reactive", "smallrye-reactive-messaging", "${version.smallrye.reactive.messaging}"), PomDependencyVersionMigration.dependency("io.vertx", "", "${version.vertx}"), PomDependencyVersionMigration.dependency("jakarta.ws.rs", "", "${version.jakarta.wr.rs}"), PomDependencyVersionMigration.dependency("junit", "", "${version.junit}"), PomDependencyVersionMigration.dependency("org.apache.commons", "commons-math3", null), PomDependencyVersionMigration.dependency("org.apache.hadoop", "", "${version.hadoop}"), PomDependencyVersionMigration.dependency("org.apache.spark", "", "${version.spark}"), PomDependencyVersionMigration.dependency("org.awaitility", "", "${version.awaitility}"), PomDependencyVersionMigration.dependency("org.codehaus.jackson", "jackson-mapper-asl", "${version.jackson.mapper.asl}"), PomDependencyVersionMigration.dependency("org.jboss.resteasy", "", "${version.resteasy}"), PomDependencyVersionMigration.dependency("org.scala-lang", "scala-compiler", "${version.scala}"), PomDependencyVersionMigration.dependency("org.scala-lang", "scala-dist", "${version.scala}"), PomDependencyVersionMigration.dependency("org.scala-lang", "scala-library", "${version.scala}"), PomDependencyVersionMigration.dependency("org.scala-lang", "scala-library-all", "${version.scala}"), PomDependencyVersionMigration.dependency("org.scala-lang", "scala-reflect", "${version.scala}"), PomDependencyVersionMigration.dependency("org.scala-lang", "scala-scalap", "${version.scala}"), PomDependencyVersionMigration.dependency("org.slf4j", "", "${version.slf4j}"));

    @Override
    protected boolean shouldExecuteOnFile(File pomFile) {
        Model model = PomHelper.getLocationAnnotatedModel((File)pomFile);
        return !this.getMatchingDependenciesWithDifferentVersionsForProject(model).isEmpty();
    }

    @Override
    protected boolean performMigration(File pomFile) {
        logger.info("Migrating file to latest aiSSEMBLE dependency versions: {}", (Object)pomFile.getAbsolutePath());
        Model model = PomHelper.getLocationAnnotatedModel((File)pomFile);
        List<Dependency> matchingDependencies = this.getMatchingDependenciesWithDifferentVersionsForProject(model);
        PomModifications modifications = new PomModifications();
        for (Dependency matchingDependency : matchingDependencies) {
            String updatedVersion = this.getUpdatedDependencyVersion(matchingDependency);
            if (matchingDependency.getVersion() != null) {
                if (updatedVersion != null) {
                    modifications.add((Object)PomDependencyVersionMigration.replaceInTag((InputLocationTracker)matchingDependency, "version", updatedVersion));
                    continue;
                }
                modifications.add((Object)PomDependencyVersionMigration.deleteTag((InputLocationTracker)matchingDependency, "version"));
                continue;
            }
            if (updatedVersion == null) continue;
            int indentSize = matchingDependency.getLocation((Object)("artifactId" + LocationAwareMavenReader.START)).getColumnNumber() - 1;
            String indent = StringUtils.repeat((char)' ', (int)indentSize);
            modifications.add((Object)new PomModifications.Insertion(matchingDependency.getLocation((Object)LocationAwareMavenReader.END), 0, ignore -> indent + "<version>" + updatedVersion + "</version>\n"));
        }
        if (!modifications.isEmpty()) {
            PomHelper.writeModifications((File)pomFile, (PomModifications.Final)modifications.finalizeMods());
        }
        return true;
    }

    private static Dependency dependency(String groupId, String artifactId, String version) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        return dependency;
    }

    private List<Dependency> getMatchingDependenciesWithDifferentVersionsForProject(Model model) {
        ArrayList<Dependency> matchingDependencies = new ArrayList<Dependency>();
        this.getMatchingDependenciesForProject(model, dependency -> true).stream().filter(this::dependencyRequiresUpdate).forEach(matchingDependencies::add);
        return matchingDependencies;
    }

    private boolean dependencyRequiresUpdate(Dependency dependency) {
        return DEPENDENCIES_TO_UPDATE.stream().filter(updatedDependency -> this.isMatchingDependency(dependency, (Dependency)updatedDependency)).anyMatch(updatedDependency -> dependency.getVersion() == null && updatedDependency.getVersion() != null || dependency.getVersion() != null && !dependency.getVersion().equals(updatedDependency.getVersion()));
    }

    private boolean isMatchingDependency(Dependency dependencyToTest, Dependency templateDependency) {
        return dependencyToTest.getGroupId().equals(templateDependency.getGroupId()) && dependencyToTest.getArtifactId().startsWith(templateDependency.getArtifactId());
    }

    private String getUpdatedDependencyVersion(Dependency dependency) {
        return DEPENDENCIES_TO_UPDATE.stream().filter(updatedDependency -> this.isMatchingDependency(dependency, (Dependency)updatedDependency)).findFirst().map(Dependency::getVersion).orElse(null);
    }
}

