/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration.v1_10_0;

import com.boozallen.aissemble.upgrade.migration.AbstractPomMigration;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.util.pom.LocationAwareMavenReader;
import org.technologybrewery.baton.util.pom.PomHelper;
import org.technologybrewery.baton.util.pom.PomModifications;

public class QuarkusBomMigration
extends AbstractPomMigration {
    private static final Logger logger = LoggerFactory.getLogger(QuarkusBomMigration.class);
    private static final String AISSEMBLE_GROUP_ID = "com.boozallen.aissemble";
    private static final String AISSEMBLE_QUARKUS_BOM_ARTIFACT_ID = "aissemble-quarkus-bom";
    private static final String AISSEMBLE_VERSION = "${version.aissemble}";

    @Override
    protected boolean shouldExecuteOnFile(File pomFile) {
        Model model = PomHelper.getLocationAnnotatedModel((File)pomFile);
        return !this.getMatchingDependenciesForProject(model, QuarkusBomMigration::isQuarkusBom).isEmpty();
    }

    @Override
    protected boolean performMigration(File pomFile) {
        logger.info("Migrating file to aiSSEMBLE Quarkus BOM: {}", (Object)pomFile.getAbsolutePath());
        Model model = PomHelper.getLocationAnnotatedModel((File)pomFile);
        List<Dependency> quarkusBomDependencies = this.getMatchingDependenciesForProject(model, QuarkusBomMigration::isQuarkusBom);
        PomModifications modifications = new PomModifications();
        for (Dependency dependency : quarkusBomDependencies) {
            modifications.add((Object)QuarkusBomMigration.replaceInTag((InputLocationTracker)dependency, "groupId", AISSEMBLE_GROUP_ID));
            modifications.add((Object)QuarkusBomMigration.replaceInTag((InputLocationTracker)dependency, "artifactId", AISSEMBLE_QUARKUS_BOM_ARTIFACT_ID));
            if (dependency.getLocation((Object)"version") != null) {
                modifications.add((Object)QuarkusBomMigration.replaceInTag((InputLocationTracker)dependency, "version", AISSEMBLE_VERSION));
                continue;
            }
            int indentSize = dependency.getLocation((Object)("artifactId" + LocationAwareMavenReader.START)).getColumnNumber() - 1;
            String indent = StringUtils.repeat((char)' ', (int)indentSize);
            modifications.add((Object)new PomModifications.Insertion(dependency.getLocation((Object)LocationAwareMavenReader.END), 0, ignore -> indent + "<version>${version.aissemble}</version>\n"));
        }
        if (!modifications.isEmpty()) {
            PomHelper.writeModifications((File)pomFile, (PomModifications.Final)modifications.finalizeMods());
        }
        return true;
    }

    private static boolean isQuarkusBom(Dependency dependency) {
        return dependency.getGroupId().equals("io.quarkus") && (dependency.getArtifactId().equals("quarkus-bom") || dependency.getArtifactId().equals("quarkus-universe-bom"));
    }
}

