/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration.v1_10_0;

import com.boozallen.aissemble.upgrade.migration.AbstractPomMigration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.BatonException;
import org.technologybrewery.baton.util.FileUtils;

public class SparkPipelineMessagingCdiFactoryMigration
extends AbstractPomMigration {
    private static final Logger logger = LoggerFactory.getLogger(SparkPipelineMessagingCdiFactoryMigration.class);
    private static final String SMALLRYE_REACTIVE_MESSAGING_GROUP_ID = "io.smallrye.reactive";
    private static final String SMALLRYE_REACTIVE_MESSAGING_ARTIFACT_ID = "smallrye-reactive-messaging";
    private static final String SMALLRYE_REACTIVE_MESSAGING_KAFKA_ARTIFACT_ID = "smallrye-reactive-messaging-kafka";
    private static final String AISSEMBLE_CDI_CONTAINER_IMPORT = "import com.boozallen.aissemble.core.cdi.CdiContainer;";
    private static final String AISSEMBLE_MESSAGING_CDI_IMPORT = "import com.boozallen.aissemble.messaging.core.cdi.MessagingCdiContext;";
    private static final String AISSEMBLE_MESSAGING_CDI_OBJECT = "new MessagingCdiContext()";
    private static final String AISSEMBLE_KAFKA_MESSAGING_CDI_IMPORT = "import com.boozallen.aissemble.kafka.context.KafkaConnectorCdiContext;";
    private static final String AISSEMBLE_KAFKA_MESSAGING_CDI_OBJECT = "new KafkaConnectorCdiContext()";
    private static final String AISSEMBLE_PIPELINE_CDI_OBJECT = "new PipelinesCdiContext()";

    @Override
    protected boolean shouldExecuteOnFile(File cdiContainerFactoryFile) {
        Model model = this.getMavenProject().getModel();
        if (this.hasDependency(model, SMALLRYE_REACTIVE_MESSAGING_GROUP_ID, SMALLRYE_REACTIVE_MESSAGING_ARTIFACT_ID) && model.getPackaging().equals("jar")) {
            boolean addKafkaCdiContext = this.hasDependency(model, SMALLRYE_REACTIVE_MESSAGING_GROUP_ID, SMALLRYE_REACTIVE_MESSAGING_KAFKA_ARTIFACT_ID);
            return this.shouldMigrateCdiContainerFactoryFile(cdiContainerFactoryFile, addKafkaCdiContext);
        }
        return false;
    }

    @Override
    protected boolean performMigration(File cdiContainerFactoryFile) {
        Model model = this.getMavenProject().getModel();
        boolean addKafkaCdiContext = this.hasDependency(model, SMALLRYE_REACTIVE_MESSAGING_GROUP_ID, SMALLRYE_REACTIVE_MESSAGING_KAFKA_ARTIFACT_ID);
        return this.migrateCdiContainerFactoryFile(cdiContainerFactoryFile, addKafkaCdiContext);
    }

    private boolean shouldMigrateCdiContainerFactoryFile(File file, boolean addKafkaCdiContext) {
        try {
            boolean hasMessagingCdiImport = Files.readString(file.toPath()).contains(AISSEMBLE_MESSAGING_CDI_IMPORT);
            boolean hasKafkaCdiImport = Files.readString(file.toPath()).contains(AISSEMBLE_KAFKA_MESSAGING_CDI_IMPORT);
            return !hasMessagingCdiImport || !hasKafkaCdiImport && addKafkaCdiContext;
        }
        catch (IOException e) {
            throw new BatonException("Failed to read CDI container file: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private boolean migrateCdiContainerFactoryFile(File file, boolean addKafkaCdiContext) {
        logger.info("Migrating file with new CDI context object(s): {}", (Object)file.getAbsolutePath());
        try {
            ArrayList<String> newFileContents = new ArrayList<String>();
            List originalFile = FileUtils.readAllFileLines((File)file);
            boolean cdiContextAdded = false;
            boolean cdiImportAdded = false;
            boolean hasMessagingCdiImport = Files.readString(file.toPath()).contains(AISSEMBLE_MESSAGING_CDI_IMPORT);
            boolean hasKafkaCdiImport = Files.readString(file.toPath()).contains(AISSEMBLE_KAFKA_MESSAGING_CDI_IMPORT);
            for (String line : originalFile) {
                if (line.equals(AISSEMBLE_CDI_CONTAINER_IMPORT)) {
                    if (!hasMessagingCdiImport) {
                        newFileContents.add(AISSEMBLE_MESSAGING_CDI_IMPORT);
                    }
                    if (!hasKafkaCdiImport && addKafkaCdiContext) {
                        newFileContents.add(AISSEMBLE_KAFKA_MESSAGING_CDI_IMPORT);
                    }
                    cdiImportAdded = true;
                } else if (line.contains(".add(new PipelinesCdiContext());")) {
                    if (!hasMessagingCdiImport) {
                        newFileContents.add(line.replace(AISSEMBLE_PIPELINE_CDI_OBJECT, AISSEMBLE_MESSAGING_CDI_OBJECT));
                    }
                    if (!hasKafkaCdiImport && addKafkaCdiContext) {
                        newFileContents.add(line.replace(AISSEMBLE_PIPELINE_CDI_OBJECT, AISSEMBLE_KAFKA_MESSAGING_CDI_OBJECT));
                    }
                    cdiContextAdded = true;
                }
                newFileContents.add(line);
            }
            FileUtils.writeFile((File)file, newFileContents);
            return cdiImportAdded && cdiContextAdded;
        }
        catch (IOException e) {
            throw new BatonException("Failed to update the file with the new CDI context object(s): " + file.getAbsolutePath(), (Throwable)e);
        }
    }
}

