/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration.v1_10_0;

import com.boozallen.aissemble.upgrade.migration.AbstractPomMigration;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.util.pom.LocationAwareMavenReader;
import org.technologybrewery.baton.util.pom.PomHelper;
import org.technologybrewery.baton.util.pom.PomModifications;

public class SparkPipelineMessagingPomMigration
extends AbstractPomMigration {
    private static final Logger logger = LoggerFactory.getLogger(SparkPipelineMessagingPomMigration.class);
    private static final String SMALLRYE_REACTIVE_MESSAGING_GROUP_ID = "io.smallrye.reactive";
    private static final String SMALLRYE_REACTIVE_MESSAGING_KAFKA_ARTIFACT_ID = "smallrye-reactive-messaging-kafka";
    private static final String AISSEMBLE_GROUP_ID = "com.boozallen.aissemble";
    private static final String AISSEMBLE_MESSAGING_KAFKA_ARTIFACT_ID = "extensions-messaging-kafka";

    @Override
    protected boolean shouldExecuteOnFile(File pomFile) {
        Model model = PomHelper.getLocationAnnotatedModel((File)pomFile);
        if (model.getPackaging().equals("jar")) {
            return this.hasDependency(model, SMALLRYE_REACTIVE_MESSAGING_GROUP_ID, SMALLRYE_REACTIVE_MESSAGING_KAFKA_ARTIFACT_ID) && !this.hasDependency(model, AISSEMBLE_GROUP_ID, AISSEMBLE_MESSAGING_KAFKA_ARTIFACT_ID);
        }
        return false;
    }

    @Override
    protected boolean performMigration(File pomFile) {
        logger.info("Migrating file with new CDI messaging dependency: {}", (Object)pomFile.getAbsolutePath());
        Model model = PomHelper.getLocationAnnotatedModel((File)pomFile);
        this.detectAndSetIndent(pomFile);
        PomModifications modifications = new PomModifications();
        modifications.add((Object)new PomModifications.Insertion(model.getLocation((Object)("dependencies" + LocationAwareMavenReader.END)), 1, this::getDependencyContent));
        return PomHelper.writeModifications((File)pomFile, (PomModifications.Final)modifications.finalizeMods());
    }

    private String getDependencyContent(String ignore) {
        return StringUtils.repeat((String)this.indent, (int)2) + "<dependency>\n" + StringUtils.repeat((String)this.indent, (int)3) + "<groupId>com.boozallen.aissemble</groupId>\n" + StringUtils.repeat((String)this.indent, (int)3) + "<artifactId>extensions-messaging-kafka</artifactId>\n" + StringUtils.repeat((String)this.indent, (int)2) + "</dependency>\n";
    }
}

