/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration.v1_10_0;

import com.boozallen.aissemble.upgrade.migration.AbstractPomMigration;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.util.pom.LocationAwareMavenReader;
import org.technologybrewery.baton.util.pom.PomHelper;
import org.technologybrewery.baton.util.pom.PomModifications;

public class SparkPipelineServletApiMigration
extends AbstractPomMigration {
    private static final Logger logger = LoggerFactory.getLogger(SparkPipelineServletApiMigration.class);
    private static final String JAVAX_SERVLET_GROUP_ID = "javax.servlet";
    private static final String JAVAX_SERVLET_ARTIFACT_ID = "javax.servlet-api";

    @Override
    protected boolean shouldExecuteOnFile(File pomFile) {
        Model model = PomHelper.getLocationAnnotatedModel((File)pomFile);
        return model.getPackaging().equals("jar") && !this.hasDependency(model, JAVAX_SERVLET_GROUP_ID, JAVAX_SERVLET_ARTIFACT_ID);
    }

    @Override
    protected boolean performMigration(File pomFile) {
        logger.info("Migrating file to include the Javax Servlet API dependency: {}", (Object)pomFile.getAbsolutePath());
        Model model = PomHelper.getLocationAnnotatedModel((File)pomFile);
        this.detectAndSetIndent(pomFile);
        PomModifications modifications = new PomModifications();
        modifications.add((Object)new PomModifications.Insertion(model.getLocation((Object)("dependencies" + LocationAwareMavenReader.END)), 1, this::getDependencyContent));
        return PomHelper.writeModifications((File)pomFile, (PomModifications.Final)modifications.finalizeMods());
    }

    private String getDependencyContent(String ignore) {
        return StringUtils.repeat((String)this.indent, (int)2) + "<dependency>\n" + StringUtils.repeat((String)this.indent, (int)3) + "<!-- Spark hasn't migrated to Jakarta packages yet. Will need to shade it if we want to fully migrate. -->\n" + StringUtils.repeat((String)this.indent, (int)3) + "<!-- See https://github.com/apache/incubator-hugegraph-toolchain/issues/464 -->\n" + StringUtils.repeat((String)this.indent, (int)3) + "<groupId>javax.servlet</groupId>\n" + StringUtils.repeat((String)this.indent, (int)3) + "<artifactId>javax.servlet-api</artifactId>\n" + StringUtils.repeat((String)this.indent, (int)3) + "<version>${version.javax.servlet}</version>\n" + StringUtils.repeat((String)this.indent, (int)2) + "</dependency>\n";
    }
}

