/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration.v1_10_0;

import com.boozallen.aissemble.upgrade.migration.AbstractAissembleMigration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class SparkVersionUpgradeMigration
extends AbstractAissembleMigration {
    private static final String OLD_FAILURE_VALIDITY_INTERVAL = "spark.yarn.executor.failuresValidityInterval";
    private static final String NEW_FAILURE_VALIDITY_INTERVAL = "spark.executor.failuresValidityInterval";
    private static final String OLD_MAX_FAILURES = "spark.yarn.max.executor.failures";
    private static final String NEW_MAX_FAILURES = "spark.executor.maxNumFailures";

    @Override
    protected boolean shouldExecuteOnFile(File file) {
        try {
            return Files.readString(file.toPath()).contains(OLD_FAILURE_VALIDITY_INTERVAL) || Files.readString(file.toPath()).contains(OLD_MAX_FAILURES);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean performMigration(File file) {
        try {
            Files.writeString(file.toPath(), (CharSequence)Files.readString(file.toPath()).replace(OLD_FAILURE_VALIDITY_INTERVAL, NEW_FAILURE_VALIDITY_INTERVAL), new OpenOption[0]);
            Files.writeString(file.toPath(), (CharSequence)Files.readString(file.toPath()).replace(OLD_MAX_FAILURES, NEW_MAX_FAILURES), new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

