/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TiltfileUtil {
    public static final String COLON = ":";
    public static final String EQUALS = "=";
    public static final String VERSION_AISSEMBLE_PRE_1_5_0 = "'VERSION_AISSEMBLE'";
    public static final String VERSION_AISSEMBLE_PRE_1_5_0_REGEX = "(.*['\"]VERSION_AISSEMBLE['\"]: *)(['\"]\\d+.\\d+.\\d+[-\\da-zA-Z]*['\"])(.*)";
    public static final String VERSION_AISSEMBLE_PRE_PIPELINE = "helm template";
    public static final String VERSION_AISSEMBLE_PRE_PIPELINE_REGEX = "(.*--version )(\\d+.\\d+.\\d+[-\\da-zA-Z]*)(.*)(\\))";
    public static final String VERSION_AISSEMBLE_POST_1_5_0 = "aissemble_version";
    public static final String VERSION_AISSEMBLE_POST_1_5_0_REGEX = "(aissemble_version *= *['\"])(\\d+.\\d+.\\d+[-\\da-zA-Z]*)(['\"])";

    public static String extractAissembleVersion(String line) {
        if (line.trim().matches(VERSION_AISSEMBLE_POST_1_5_0_REGEX)) {
            int index = line.indexOf(VERSION_AISSEMBLE_POST_1_5_0);
            String result = index != -1 ? line.substring(index) : line;
            String[] parts = result.split(EQUALS);
            if (parts.length != 2 || !result.contains(EQUALS)) {
                return null;
            }
            String tiltfileVersionvalue = parts[1].replaceAll("['|\"]", "").trim();
            return tiltfileVersionvalue;
        }
        if (line.trim().matches(VERSION_AISSEMBLE_PRE_1_5_0_REGEX)) {
            Pattern pattern = Pattern.compile(VERSION_AISSEMBLE_PRE_1_5_0_REGEX, 8);
            Matcher matcher = pattern.matcher(line);
            matcher.matches();
            String tiltfileVersionvalue = matcher.group(2).replaceAll("['|\"]", "");
            return tiltfileVersionvalue;
        }
        return null;
    }
}

