/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.util;

import com.boozallen.aissemble.upgrade.pojo.AbstractYamlObject;
import com.google.common.base.CaseFormat;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.representer.Representer;

public class YamlUtils {
    private static final String SPACE = " ";
    private static final int TAB = 2;

    public static YamlObject loadYaml(File file) throws IOException {
        Yaml yaml = new Yaml();
        try (InputStream fileStream = Files.asByteSource((File)file).openStream();){
            Map<String, Object> contents;
            Object data = yaml.load(fileStream);
            if (data == null) {
                contents = Map.of();
            } else if (data instanceof Map) {
                contents = (Map<String, Object>)data;
            } else if (data instanceof List) {
                contents = Map.of("items", data);
            } else {
                throw new YAMLException("Unrecognized root data type [" + data.getClass().getName() + "] in file: " + file.getAbsolutePath());
            }
            YamlObject yamlObject = new YamlObject(contents);
            return yamlObject;
        }
    }

    public static boolean isComment(String trimmedLine) {
        return trimmedLine.startsWith("#") || trimmedLine.matches("\\{\\{-? */\\*.*");
    }

    public static boolean isHelmFunction(String trimmedLine) {
        return trimmedLine.startsWith("{{");
    }

    public static <T extends AbstractYamlObject> T createYamlObjectFromFile(File file, Class<T> clazz, Logger logger) {
        Representer representer = new Representer(new DumperOptions());
        representer.getPropertyUtils().setSkipMissingProperties(true);
        LoaderOptions loaderOptions = new LoaderOptions();
        Constructor constructor = new Constructor(clazz, loaderOptions);
        constructor.setPropertyUtils(new PropertyUtils(){

            public Property getProperty(Class<? extends Object> type, String name) {
                if (name.contains("-")) {
                    name = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name);
                }
                return super.getProperty(type, name);
            }
        });
        constructor.getPropertyUtils().setSkipMissingProperties(true);
        Yaml helmYaml = new Yaml((BaseConstructor)constructor, representer);
        AbstractYamlObject helmYamlObject = null;
        try {
            InputStream fileStream = Files.asByteSource((File)file).openStream();
            helmYamlObject = (AbstractYamlObject)helmYaml.load(fileStream);
        }
        catch (IOException e) {
            logger.error("Unable to load file into yaml class due to exception:", (Throwable)e);
        }
        return (T)helmYamlObject;
    }

    public static String indent(int level, int tab) {
        return StringUtils.repeat((String)SPACE, (int)(level * tab));
    }

    public static String indent(int level) {
        return StringUtils.repeat((String)SPACE, (int)(level * 2));
    }

    public static int getIndentSpaces(List<String> yamlFileContent, int startIndex) {
        int indentSpaces = 0;
        int index = startIndex;
        while (indentSpaces == 0) {
            String line = yamlFileContent.get(index).stripTrailing();
            if (!(StringUtils.isBlank((CharSequence)line) || YamlUtils.isComment(line.trim()) || YamlUtils.isHelmFunction(line.trim()))) {
                indentSpaces = line.indexOf(line.trim());
            }
            ++index;
        }
        return indentSpaces;
    }

    public static class YamlObject {
        private final Map<String, Object> contents;

        public YamlObject(Map<String, Object> contents) {
            this.contents = contents;
        }

        public boolean hasString(String ... path) {
            return this.hasValue(String.class, path);
        }

        public String getString(String ... path) {
            return (String)this.getValue(path);
        }

        public boolean hasInt(String ... path) {
            return this.hasValue(Integer.class, path);
        }

        public int getInt(String ... path) {
            return (Integer)this.getValue(path);
        }

        public boolean hasDouble(String ... path) {
            return this.hasValue(Double.class, path);
        }

        public double getDouble(String ... path) {
            return (Double)this.getValue(path);
        }

        public boolean hasBoolean(String ... path) {
            return this.hasValue(Boolean.class, path);
        }

        public boolean getBoolean(String ... path) {
            return (Boolean)this.getValue(path);
        }

        public boolean hasObject(String ... path) {
            YamlObject obj = this;
            for (String key : path) {
                if (!obj.containsKey(key) || !(obj.get(key) instanceof Map)) {
                    return false;
                }
                obj = obj.getObject(key);
            }
            return true;
        }

        public YamlObject getObject(String ... path) {
            YamlObject obj = this;
            for (String key : path) {
                Object value = obj.get(key);
                if (!(value instanceof Map)) {
                    throw new IllegalArgumentException(String.format("Value for [%s] is not of type Map: %s", key, value));
                }
                obj = new YamlObject((Map)value);
            }
            return obj;
        }

        public boolean hasList(String ... path) {
            return this.hasValue(List.class, path);
        }

        public List<?> getList(String ... path) {
            return (List)this.getValue(path);
        }

        public List<YamlObject> getListOfObjects(String ... path) {
            List<?> list = this.getList(path);
            if (list.stream().anyMatch(o -> !(o instanceof Map))) {
                throw new IllegalArgumentException("List contains non-map elements: " + list);
            }
            return list.stream().map(o -> (Map)o).map(YamlObject::new).collect(Collectors.toList());
        }

        public List<String> getListOfStrings(String ... path) {
            List<String> list = this.getList(path);
            if (list.stream().anyMatch(o -> !(o instanceof String))) {
                throw new IllegalArgumentException("List contains non-string elements: " + list);
            }
            return list;
        }

        @Nonnull
        public Object get(String key) {
            if (!this.containsKey(key)) {
                throw new NoSuchElementException("Key not found: " + key);
            }
            return this.contents.get(key);
        }

        public boolean containsKey(String key) {
            return this.contents.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.contents.containsValue(value);
        }

        public boolean isEmpty() {
            return this.contents.isEmpty();
        }

        public int size() {
            return this.contents.size();
        }

        public Set<String> keySet() {
            return this.contents.keySet();
        }

        public Collection<Object> values() {
            return this.contents.values();
        }

        public Set<Map.Entry<String, Object>> entrySet() {
            return this.contents.entrySet();
        }

        private <T> boolean hasValue(Class<T> type, String ... path) {
            YamlObject parent = this.getParentIfExists(path);
            if (parent == null) {
                return false;
            }
            String key = path[path.length - 1];
            return parent.containsKey(key) && type.isInstance(parent.get(key));
        }

        private <T> T getValue(String ... path) {
            YamlObject parent = this.getParentIfExists(path);
            if (parent == null) {
                throw new NoSuchElementException("Parent object does not exist at " + Arrays.toString(path));
            }
            String key = path[path.length - 1];
            return (T)parent.get(key);
        }

        private YamlObject getParentIfExists(String[] path) {
            if (path.length == 0) {
                throw new IllegalArgumentException("Root path is always an object");
            }
            String[] parentPath = Arrays.copyOf(path, path.length - 1);
            YamlObject parent = null;
            if (this.hasObject(parentPath)) {
                parent = this.getObject(parentPath);
            }
            return parent;
        }
    }
}

