/*
 * Decompiled with CFR 0.152.
 */
package com.bordercloud.sparql;

import com.bordercloud.sparql.Datatype;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParserSparqlResultHandler
extends DefaultHandler {
    private HashMap<String, Object> _result;
    private int _rowCurrent;
    private String _cellCurrent;
    private StringBuffer _value;

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this._result = new HashMap();
    }

    public HashMap<String, Object> getResult() {
        return this._result;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equalsIgnoreCase("sparql")) {
            this._result.remove("boolean");
            this._result.put("result", new HashMap());
        } else if (name.equalsIgnoreCase("head")) {
            ((HashMap)this._result.get("result")).put("variables", new ArrayList());
        } else if (name.equalsIgnoreCase("variable")) {
            ((ArrayList)((HashMap)this._result.get("result")).get("variables")).add(attributes.getValue("name"));
        } else if (name.equalsIgnoreCase("results")) {
            this._rowCurrent = -1;
            ((HashMap)this._result.get("result")).put("rows", new ArrayList());
        } else if (name.equalsIgnoreCase("result")) {
            ++this._rowCurrent;
            ((ArrayList)((HashMap)this._result.get("result")).get("rows")).add(new HashMap());
        } else if (name.equalsIgnoreCase("binding")) {
            this._value = new StringBuffer();
            this._cellCurrent = attributes.getValue("name");
        } else if (this._cellCurrent != null) {
            this.addValueCurrentRow(this._cellCurrent + " type", name);
            if (attributes.getValue("xml:lang") != null) {
                this.addValueCurrentRow(this._cellCurrent + " lang", attributes.getValue("xml:lang"));
            }
            if (attributes.getValue("datatype") != null) {
                this.addValueCurrentRow(this._cellCurrent + " datatype", attributes.getValue("datatype"));
            }
        } else if (name.equalsIgnoreCase("boolean")) {
            this._value = new StringBuffer();
            this._cellCurrent = "boolean";
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equalsIgnoreCase("binding")) {
            String value = "";
            if (this._value == null) {
                return;
            }
            value = this._value.toString().trim();
            if (value.length() == 0) {
                return;
            }
            if (!this.isKeyExistCurrentRow(this._cellCurrent + " type")) {
                this.addValueCurrentRow(this._cellCurrent + " type", null);
            }
            if (this.getValueCurrentRow(this._cellCurrent + " type") == "uri") {
                this.addValueCurrentRow(this._cellCurrent, value);
            } else if (this.getValueCurrentRow(this._cellCurrent + " type") == "bnode") {
                this.addValueCurrentRow(this._cellCurrent, value);
            } else if (this.getValueCurrentRow(this._cellCurrent + " type") == "literal") {
                if (this.isKeyExistCurrentRow(this._cellCurrent + " datatype")) {
                    switch (Datatype.find((String)this.getValueCurrentRow(this._cellCurrent + " datatype"))) {
                        case xsdshort: 
                        case xsdunsignedByte: {
                            this.addValueCurrentRow(this._cellCurrent, new Short(value));
                            break;
                        }
                        case xsdint: 
                        case xsdunsignedShort: {
                            this.addValueCurrentRow(this._cellCurrent, new Integer(value));
                            break;
                        }
                        case xsdinteger: 
                        case xsdnonPositiveInteger: 
                        case xsdnegativeInteger: 
                        case xsdnonNegativeInteger: 
                        case xsdpositiveInteger: {
                            this.addValueCurrentRow(this._cellCurrent, new BigInteger(value));
                            break;
                        }
                        case xsdlong: 
                        case xsdunsignedInt: 
                        case xsdunsignedLong: {
                            this.addValueCurrentRow(this._cellCurrent, new Long(value));
                            break;
                        }
                        case xsddecimal: {
                            this.addValueCurrentRow(this._cellCurrent, new BigDecimal(value));
                            break;
                        }
                        case xsdfloat: {
                            this.addValueCurrentRow(this._cellCurrent, new Float(value));
                            break;
                        }
                        case xsddouble: {
                            this.addValueCurrentRow(this._cellCurrent, new Double(value));
                            break;
                        }
                        case xsdbyte: {
                            this.addValueCurrentRow(this._cellCurrent, new Byte(value));
                            break;
                        }
                        case xsddateTime: {
                            TemporalAccessor ta = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(value);
                            Instant i = Instant.from(ta);
                            GregorianCalendar datetime = GregorianCalendar.from(ZonedDateTime.from(i));
                            this.addValueCurrentRow(this._cellCurrent, datetime);
                            break;
                        }
                        default: {
                            this.addValueCurrentRow(this._cellCurrent, value);
                            break;
                        }
                    }
                } else {
                    this.addValueCurrentRow(this._cellCurrent, value);
                }
            } else {
                this.addValueCurrentRow(this._cellCurrent, value);
            }
            this._cellCurrent = null;
            this._value = new StringBuffer();
        } else if (name.equalsIgnoreCase("boolean")) {
            boolean bool = false;
            if (this._value != null) {
                bool = this._value.toString().trim().equalsIgnoreCase("true");
            }
            this._result.put("boolean", bool);
            this._result.remove("result");
            this._cellCurrent = null;
            this._value = new StringBuffer();
        }
    }

    private void addValueCurrentRow(String key, Object value) {
        ((HashMap)((ArrayList)((HashMap)this._result.get("result")).get("rows")).get(this._rowCurrent)).put(key, value);
    }

    private boolean isKeyExistCurrentRow(String key) {
        return null != ((HashMap)((ArrayList)((HashMap)this._result.get("result")).get("rows")).get(this._rowCurrent)).get(key);
    }

    private Object getValueCurrentRow(String key) {
        return ((HashMap)((ArrayList)((HashMap)this._result.get("result")).get("rows")).get(this._rowCurrent)).get(key);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._cellCurrent != null && this._value != null) {
            this._value.append(ch, start, length);
        }
    }
}

