/*
 * Decompiled with CFR 0.152.
 */
package com.bordercloud.sparql;

import com.bordercloud.sparql.Method;
import com.bordercloud.sparql.MimeType;
import com.bordercloud.sparql.Network;
import com.bordercloud.sparql.ParserSparqlResultHandler;
import com.bordercloud.sparql.SparqlClientException;
import com.bordercloud.sparql.SparqlQueryType;
import com.bordercloud.sparql.SparqlResult;
import com.bordercloud.sparql.SparqlResultModel;
import com.bordercloud.sparql.SparqlResultModelWithJSON;
import com.bordercloud.sparql.SparqlResultModelWithXML;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SparqlClient {
    private SparqlResult _result = null;
    private String _lastQuery;
    private HttpUriRequest _lastHTTPRequest = null;
    private CloseableHttpResponse _lastHTTPResponse = null;
    private String _userAgent = "BorderCloud/Sparql-JAVA 2.0";
    public URI _endpointRead = null;
    public URI _endpointWrite = null;
    public boolean _debug = false;
    public String _proxyHost = null;
    public int _proxyPort = 0;
    public ParserSparqlResultHandler _parserSparqlResult = null;
    public String _nameParameterQueryRead = null;
    public String _nameParameterQueryWrite = null;
    public Method _methodHTTPRead = null;
    public Method _methodHTTPWrite = null;
    public String _login = null;
    public String _password = null;
    private SAXParser _parser;
    private DefaultHandler _handler;
    public Object _lastError = null;
    private static Pattern PATTERN_UPDATE = Pattern.compile("(INSERT|DELETE|CLEAR|LOAD)", 2);
    private static Pattern PATTERN_CONSTRUCT = Pattern.compile("CONSTRUCT", 2);
    private static Pattern PATTERN_ASK = Pattern.compile("ASK", 2);
    private static Pattern PATTERN_DESCRIBE = Pattern.compile("DESCRIBE", 2);

    public SparqlClient() {
        this.init(false, null, 0);
    }

    public SparqlClient(boolean debug) {
        this.init(debug, null, 0);
    }

    public SparqlClient(boolean debug, String proxyHost, int proxyPort) {
        this.init(debug, proxyHost, proxyPort);
    }

    private void init(boolean debug, String proxyHost, int proxyPort) {
        this._debug = debug;
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
        this._methodHTTPRead = Method.POST;
        this._methodHTTPWrite = Method.POST;
        this._nameParameterQueryRead = "query";
        this._nameParameterQueryWrite = "update";
        this._parserSparqlResult = new ParserSparqlResultHandler();
        this._lastError = "";
        SAXParserFactory parserSparql = SAXParserFactory.newInstance();
        this._parser = null;
        try {
            this._parser = parserSparql.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this._handler = new ParserSparqlResultHandler();
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        if (this._debug) {
            Logger.getLogger("org.apache.http.wire").setLevel(Level.FINEST);
            Logger.getLogger("org.apache.http.headers").setLevel(Level.FINEST);
            System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
            System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "debug");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "debug");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.headers", "debug");
        }
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this._proxyPort = proxyPort;
    }

    public void setMethodHTTPRead(Method method) {
        this._methodHTTPRead = method;
    }

    public Method getMethodHTTPRead() {
        return this._methodHTTPRead;
    }

    public void setMethodHTTPWrite(Method method) {
        this._methodHTTPWrite = method;
    }

    public Method getMethodHTTPWrite() {
        return this._methodHTTPWrite;
    }

    public void setEndpointRead(URI uri) {
        if (uri.toString().equalsIgnoreCase("https://query.wikidata.org/sparql")) {
            this._methodHTTPRead = Method.GET;
        }
        this._endpointRead = uri;
    }

    public URI getEndpointRead() {
        return this._endpointRead;
    }

    public void setEndpointWrite(URI uri) {
        this._endpointWrite = uri;
    }

    public URI getEndpointWrite() {
        return this._endpointWrite;
    }

    public void setNameParameterQueryWrite(String name) {
        this._nameParameterQueryWrite = name;
    }

    public String getNameParameterQueryWrite() {
        return this._nameParameterQueryWrite;
    }

    public void setNameParameterQueryRead(String name) {
        this._nameParameterQueryRead = name;
    }

    public String getNameParameterQueryRead() {
        return this._nameParameterQueryRead;
    }

    public void setLogin(String login) {
        this._login = login;
    }

    public String getLogin() {
        return this._login;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    public boolean checkEndpointRead() {
        return Network.ping(this._endpointRead) != -1.0;
    }

    public boolean checkEndpointWrite() {
        return Network.ping(this._endpointWrite) != -1.0;
    }

    public String getLastSparqlQuery() {
        return this._lastQuery;
    }

    public HttpUriRequest getLastHTTPRequest() {
        return this._lastHTTPRequest;
    }

    public HttpResponse getLastHTTPResponse() {
        return this._lastHTTPResponse;
    }

    public SparqlResult getLastResult() {
        return this._result;
    }

    public SparqlResult query(String query) throws SparqlClientException {
        return this.query(query, MimeType.xml, "UTF-8");
    }

    public SparqlResult query(String query, MimeType typeOutput) throws SparqlClientException {
        return this.query(query, typeOutput, "UTF-8");
    }

    public SparqlResult query(String q, MimeType typeOutput, String typeCharset) throws SparqlClientException {
        this._lastQuery = q;
        long t1 = System.currentTimeMillis();
        SparqlQueryType type = SparqlClient.findType(q);
        switch (type) {
            case UPDATE: {
                this._result = this.queryUpdate(q, typeOutput, typeCharset);
                break;
            }
            case SELECT: 
            case CONSTRUCT: 
            case ASK: 
            case DESCRIBE: {
                this._result = this.queryRead(q, typeOutput, typeCharset);
            }
        }
        this._result.queryType = type;
        block4 : switch (type) {
            case UPDATE: {
                break;
            }
            case SELECT: {
                switch (this._result.accept) {
                    case xml: {
                        this._result.resultHashMap = this.getResultXml(this._result.resultRaw);
                        break block4;
                    }
                    case json: {
                        this._result.resultHashMap = this.getResultJson(this._result.resultRaw);
                        break block4;
                    }
                }
                break;
            }
            case CONSTRUCT: {
                break;
            }
            case ASK: {
                switch (this._result.accept) {
                    case xml: {
                        this._result.resultHashMap = this.getResultXml(this._result.resultRaw);
                        break block4;
                    }
                    case json: {
                        this._result.resultHashMap = this.getResultJson(this._result.resultRaw);
                        break block4;
                    }
                }
                break;
            }
            case DESCRIBE: {
                break;
            }
        }
        return this._result;
    }

    private static SparqlQueryType findType(String q) {
        SparqlQueryType result = SparqlQueryType.SELECT;
        if (PATTERN_UPDATE.matcher(q).find()) {
            result = SparqlQueryType.UPDATE;
        } else if (PATTERN_CONSTRUCT.matcher(q).find()) {
            result = SparqlQueryType.CONSTRUCT;
        } else if (PATTERN_ASK.matcher(q).find()) {
            result = SparqlQueryType.ASK;
        } else if (PATTERN_DESCRIBE.matcher(q).find()) {
            result = SparqlQueryType.DESCRIBE;
        }
        return result;
    }

    private HashMap<String, Object> getResultJson(String jsonString) throws SparqlClientException {
        try {
            return (HashMap)new ObjectMapper().readValue(jsonString, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            throw new SparqlClientException(this, e.getMessage());
        }
    }

    private HashMap<String, Object> getResultXml(String response) throws SparqlClientException {
        this._handler = new ParserSparqlResultHandler();
        try {
            this._parser.parse(new InputSource(new StringReader(response)), this._handler);
        }
        catch (SAXException e) {
            throw new SparqlClientException(this, e.getMessage());
        }
        catch (IOException e) {
            throw new SparqlClientException(this, e.getMessage());
        }
        if (this._handler != null) {
            return ((ParserSparqlResultHandler)this._handler).getResult();
        }
        return null;
    }

    public SparqlResult queryRead(String query, MimeType typeOutput, String typeCharset) throws SparqlClientException {
        if (this._endpointRead != null) {
            if (this._methodHTTPRead == Method.POST) {
                if (this._login != null && this._password != null) {
                    return this.sendQueryPOSTwithAuth(this._endpointRead, this._nameParameterQueryRead, query, typeOutput, typeCharset, this._login, this._password);
                }
                return this.sendQueryPOST(this._endpointRead, this._nameParameterQueryRead, query, typeOutput, typeCharset);
            }
            if (this._login != null && this._password != null) {
                return this.sendQueryGET(this._endpointRead, this._nameParameterQueryRead, query, typeOutput, typeCharset, this._login, this._password);
            }
            return this.sendQueryGET(this._endpointRead, this._nameParameterQueryRead, query, typeOutput, typeCharset);
        }
        throw new SparqlClientException(this, "The endpoint for reading is not defined.");
    }

    public SparqlResult queryUpdate(String query, MimeType typeOutput, String typeCharset) throws SparqlClientException {
        if (this._endpointWrite != null) {
            if (this._methodHTTPWrite == Method.POST) {
                if (this._login != null && this._password != null) {
                    return this.sendQueryPOSTwithAuth(this._endpointWrite, this._nameParameterQueryWrite, query, typeOutput, typeCharset, this._login, this._password);
                }
                return this.sendQueryPOST(this._endpointWrite, this._nameParameterQueryWrite, query, typeOutput, typeCharset);
            }
            if (this._login != null && this._password != null) {
                return this.sendQueryGET(this._endpointWrite, this._nameParameterQueryWrite, query, typeOutput, typeCharset, this._login, this._password);
            }
            return this.sendQueryGET(this._endpointWrite, this._nameParameterQueryWrite, query, typeOutput, typeCharset);
        }
        throw new SparqlClientException(this, "The endpoint for writing is not defined.");
    }

    private SparqlResult sendQueryGET(URI endpoint, String nameParameter, String query, MimeType typeOutput, String typeCharset) throws SparqlClientException {
        return this.sendQueryGET(endpoint, nameParameter, query, typeOutput, typeCharset, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparqlResult sendQueryGET(URI endpoint, String nameParameter, String query, MimeType typeOutput, String typeCharset, String login, String password) throws SparqlClientException {
        SparqlResult result = new SparqlResult();
        try {
            URIBuilder uriBuilder = new URIBuilder(endpoint);
            uriBuilder.setCharset(Charset.forName(typeCharset));
            uriBuilder.addParameter(nameParameter, query);
            if (login != null && password != null) {
                uriBuilder.setUserInfo(login, password);
            }
            URI url = uriBuilder.build();
            try (CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(60000).setExpectContinueEnabled(false).setSocketTimeout(60000).setCookieSpec("easy").build()).setMaxConnPerRoute(20).setMaxConnTotal(100).build();){
                HttpGet httpget = new HttpGet(url);
                httpget.setHeader("Accept", typeOutput.getMimetype());
                httpget.setHeader("Accept-Charset", typeCharset);
                httpget.setHeader("User-Agent", this._userAgent);
                this._lastHTTPRequest = httpget;
                this._lastHTTPResponse = httpclient.execute(this._lastHTTPRequest);
                try {
                    int statusCode = this._lastHTTPResponse.getStatusLine().getStatusCode();
                    HttpEntity entity = this._lastHTTPResponse.getEntity();
                    result.resultRaw = EntityUtils.toString((HttpEntity)entity, (String)typeCharset);
                    result.accept = typeOutput;
                    if (statusCode < 200 || statusCode >= 300) {
                        this._result = result;
                        throw new SparqlClientException(this, this._lastHTTPResponse.getStatusLine().toString());
                    }
                }
                finally {
                    this._lastHTTPResponse.close();
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            this._result = result;
            throw new SparqlClientException(this, e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparqlResult sendQueryPOSTwithAuth(URI endpoint, String nameParameter, String query, MimeType typeOutput, String typeCharset, String login, String password) throws SparqlClientException {
        SparqlResult result = new SparqlResult();
        try {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(login, password));
            try (CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(60000).setExpectContinueEnabled(false).setSocketTimeout(60000).setCookieSpec("easy").build()).setMaxConnPerRoute(20).setMaxConnTotal(100).build();){
                HttpPost httpPost = new HttpPost(endpoint);
                httpPost.setHeader("Accept", typeOutput.getMimetype());
                httpPost.setHeader("Accept-Charset", typeCharset);
                httpPost.setHeader("User-Agent", this._userAgent);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair(nameParameter, query));
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, typeCharset));
                this._lastHTTPRequest = httpPost;
                this._lastHTTPResponse = httpclient.execute(this._lastHTTPRequest);
                try {
                    int statusCode = this._lastHTTPResponse.getStatusLine().getStatusCode();
                    HttpEntity entity = this._lastHTTPResponse.getEntity();
                    result.resultRaw = EntityUtils.toString((HttpEntity)entity, (String)typeCharset);
                    result.accept = typeOutput;
                    if (statusCode < 200 || statusCode >= 300) {
                        this._result = result;
                        throw new SparqlClientException(this, this._lastHTTPResponse.getStatusLine().toString());
                    }
                }
                finally {
                    this._lastHTTPResponse.close();
                }
            }
        }
        catch (IOException e) {
            this._result = result;
            throw new SparqlClientException(this, e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparqlResult sendQueryPOST(URI endpoint, String nameParameter, String query, MimeType typeOutput, String typeCharset) throws SparqlClientException {
        SparqlResult result = new SparqlResult();
        try (CloseableHttpClient httpclient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(60000).setExpectContinueEnabled(false).setSocketTimeout(60000).setCookieSpec("easy").build()).setMaxConnPerRoute(20).setMaxConnTotal(100).build();){
            HttpPost httpPost = new HttpPost(endpoint);
            httpPost.setHeader("Accept", typeOutput.getMimetype());
            httpPost.setHeader("Accept-Charset", typeCharset);
            httpPost.setHeader("User-Agent", this._userAgent);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair(nameParameter, query));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, typeCharset));
            this._lastHTTPRequest = httpPost;
            this._lastHTTPResponse = httpclient.execute(this._lastHTTPRequest);
            try {
                int statusCode = this._lastHTTPResponse.getStatusLine().getStatusCode();
                HttpEntity entity = this._lastHTTPResponse.getEntity();
                result.resultRaw = EntityUtils.toString((HttpEntity)entity, (String)typeCharset);
                result.accept = typeOutput;
                if (statusCode < 200 || statusCode >= 300) {
                    this._result = result;
                    throw new SparqlClientException(this, this._lastHTTPResponse.getStatusLine().toString());
                }
            }
            finally {
                this._lastHTTPResponse.close();
            }
        }
        catch (IOException e) {
            this._result = result;
            throw new SparqlClientException(this, e.getMessage());
        }
        return result;
    }

    public void printLastQueryAndResult() {
        SparqlClient.printLastQueryAndResult(this);
    }

    public static void printLastQueryAndResult(SparqlClient c) {
        System.out.println("");
        System.out.println("Endpoint Read : " + c.getEndpointRead());
        System.out.println("Endpoint Write : " + c.getEndpointRead());
        System.out.println("Query : ");
        System.out.println(c.getLastSparqlQuery());
        System.out.println("");
        System.out.println("Result : ");
        SparqlQueryType type = SparqlClient.findType(c.getLastSparqlQuery());
        switch (type) {
            case UPDATE: {
                System.out.println("Result : " + c._result.resultRaw);
                break;
            }
            case SELECT: 
            case CONSTRUCT: 
            case ASK: 
            case DESCRIBE: {
                SparqlClient.printSparqlResult(c);
            }
        }
    }

    private static void printSparqlResult(SparqlClient c) {
        switch (c.getLastResult().accept) {
            case xml: {
                SparqlResultModelWithXML srmx = new SparqlResultModelWithXML(c.getLastResult().resultHashMap);
                SparqlResultModel.printResult(srmx, 30);
                break;
            }
            case json: {
                SparqlResultModelWithJSON srmj = new SparqlResultModelWithJSON(c.getLastResult().resultHashMap);
                SparqlResultModel.printResult(srmj, 30);
                break;
            }
            default: {
                System.out.println(c.getLastResult().resultRaw);
            }
        }
    }
}

