/*
 * Decompiled with CFR 0.152.
 */
package com.bordercloud.sparql;

import com.bordercloud.sparql.SparqlClient;
import com.bordercloud.sparql.SparqlResult;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;

public class SparqlClientException
extends Exception {
    SparqlClient _sparqlClient;

    public SparqlClientException(SparqlClient sparqlClient, String message) {
        super(message);
        this._sparqlClient = sparqlClient;
    }

    @Override
    public String getMessage() {
        String message = "";
        String response = "";
        if (this._sparqlClient.getLastHTTPRequest() != null && this._sparqlClient.getLastHTTPResponse() != null) {
            int status = this._sparqlClient.getLastHTTPResponse().getStatusLine().getStatusCode();
            SparqlResult result = this._sparqlClient.getLastResult();
            if (result != null && result.resultRaw != null) {
                response = result.resultRaw;
                Matcher matcher = Pattern.compile("MalformedQueryException: *(.*)", 2).matcher(response);
                if (matcher.find()) {
                    message = "ERROR QUERY: " + matcher.group(1);
                }
            }
            if (message.isEmpty()) {
                message = status == 200 && result != null ? result.resultRaw : "ERROR QUERY: " + this._sparqlClient.getLastSparqlQuery() + "\nERROR HTTP : " + SparqlClientException.printRequestHTTP(this._sparqlClient);
            }
        } else {
            message = super.getMessage();
        }
        return message;
    }

    private static String printRequestHTTP(SparqlClient sparqlClient) {
        String charset = null;
        Header charsetHeader = sparqlClient.getLastHTTPRequest().getFirstHeader("Accept-Charset");
        charset = charsetHeader != null ? charsetHeader.getValue() : "UTF-8";
        if (sparqlClient.getLastHTTPRequest() instanceof HttpPost) {
            return SparqlClientException.post(sparqlClient);
        }
        return SparqlClientException.get(sparqlClient);
    }

    private static String get(SparqlClient sparqlClient) {
        HttpGet request = (HttpGet)sparqlClient.getLastHTTPRequest();
        HttpResponse response = sparqlClient.getLastHTTPResponse();
        String charset = null;
        Header charsetHeader = sparqlClient.getLastHTTPRequest().getFirstHeader("Accept-Charset");
        charset = charsetHeader != null ? charsetHeader.getValue() : "UTF-8";
        StringBuffer str = new StringBuffer();
        URI uri = request.getURI();
        int responseCode = response.getStatusLine().getStatusCode();
        String responsePhrase = response.getStatusLine().getReasonPhrase();
        str.append("**GET** request Url: " + uri);
        str.append(" \n\n Headers");
        for (Header header : request.getAllHeaders()) {
            str.append("\n");
            str.append(header.getName() + " = " + header.getValue());
        }
        str.append("\n\nParameters");
        URIBuilder newBuilder = new URIBuilder(uri);
        List params = newBuilder.getQueryParams();
        for (NameValuePair kv : params) {
            str.append("\n");
            str.append(kv.getName() + " = " + kv.getName());
        }
        str.append("\nResponse Code: " + responseCode + "(" + responsePhrase + ")");
        str.append("\nContent:-\n");
        SparqlResult result = sparqlClient.getLastResult();
        if (result != null) {
            str.append(result.resultRaw);
        } else {
            str.append("EMPTY");
        }
        return str.toString();
    }

    private static String post(SparqlClient sparqlClient) {
        HttpPost request = (HttpPost)sparqlClient.getLastHTTPRequest();
        HttpResponse response = sparqlClient.getLastHTTPResponse();
        String charset = null;
        Header charsetHeader = sparqlClient.getLastHTTPRequest().getFirstHeader("Accept-Charset");
        charset = charsetHeader != null ? charsetHeader.getValue() : "UTF-8";
        StringBuffer str = new StringBuffer();
        try {
            int responseCode = response.getStatusLine().getStatusCode();
            String responsePhrase = response.getStatusLine().getReasonPhrase();
            str.append("\n**POST** request Url: " + request.getURI() + "\n");
            str.append("\nParameters :\n");
            String strParameters = EntityUtils.toString((HttpEntity)request.getEntity(), (String)charset);
            for (String par : strParameters.split("&")) {
                str.append("\n");
                str.append(URLDecoder.decode(par, charset));
            }
            str.append("\nResponse Code: " + responseCode + "(" + responsePhrase + ")");
            str.append("\nContent:-\n");
            SparqlResult result = sparqlClient.getLastResult();
            if (result != null) {
                str.append(result.resultRaw);
            } else {
                str.append("EMPTY");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return str.toString();
    }
}

