/*
 * Decompiled with CFR 0.152.
 */
package com.bordercloud.sparql;

import com.bordercloud.sparql.MimeType;
import com.bordercloud.sparql.SparqlQueryType;
import com.bordercloud.sparql.SparqlResultModel;
import com.bordercloud.sparql.SparqlResultModelWithJSON;
import com.bordercloud.sparql.SparqlResultModelWithXML;
import com.bordercloud.sparql.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SparqlResult {
    public SparqlQueryType queryType;
    public MimeType accept;
    public String resultRaw;
    public HashMap<String, Object> resultHashMap;
    public boolean resultAsk;

    public SparqlResultModel getModel() {
        switch (this.queryType) {
            case SELECT: {
                if (this.accept == MimeType.json) {
                    return new SparqlResultModelWithJSON(this.resultHashMap);
                }
                if (this.accept != MimeType.xml) break;
                return new SparqlResultModelWithXML(this.resultHashMap);
            }
        }
        return null;
    }

    public boolean getAskResult() throws Exception {
        if (this.queryType != SparqlQueryType.ASK) {
            throw new Exception("Use getAskResult only for ASK query.");
        }
        return (Boolean)this.resultHashMap.get("boolean");
    }

    public static void printTree(SparqlResult rs) {
        TreeNode tree = new TreeNode("sparql", SparqlResult.getTree(rs.resultHashMap));
        System.out.print(tree);
    }

    public static void printTree(HashMap rs) {
        TreeNode tree = new TreeNode("sparql", SparqlResult.getTree(rs));
        System.out.print(tree);
    }

    private static List<TreeNode> getTree(ArrayList<HashMap> rs) {
        ArrayList<TreeNode> node = new ArrayList<TreeNode>();
        int i = 0;
        for (HashMap map : rs) {
            node.add(new TreeNode(String.valueOf(i), SparqlResult.getTree(new TreeMap<Object, Object>(map))));
            ++i;
        }
        return node;
    }

    private static List<TreeNode> getTree(Map<Object, Object> rs) {
        ArrayList<TreeNode> node = new ArrayList<TreeNode>();
        rs.forEach((key, value) -> {
            if (value instanceof HashMap) {
                if (((HashMap)value).size() > 0) {
                    node.add(new TreeNode(key.toString(), SparqlResult.getTree((HashMap)value)));
                } else {
                    node.add(TreeNode.leaf(key.toString() + " = EMPTY"));
                }
            } else if (value instanceof ArrayList) {
                if (((ArrayList)value).size() > 0) {
                    if (((ArrayList)value).get(0) instanceof HashMap) {
                        node.add(new TreeNode(key.toString(), SparqlResult.getTree((ArrayList)value)));
                    } else {
                        node.add(TreeNode.leaf(key.toString() + " = " + value.toString()));
                    }
                } else {
                    node.add(TreeNode.leaf(key.toString() + " = EMPTY"));
                }
            } else {
                node.add(TreeNode.leaf(key.toString() + " = " + value.toString()));
            }
        });
        return node;
    }

    public static HashMap<Integer, Object> compare(HashMap<String, Object> rs1, HashMap<String, Object> rs2, boolean ordered, boolean distinct) {
        int i;
        HashMap<Integer, Object> differenceEmpty = new HashMap<Integer, Object>();
        HashMap<Integer, Object> difference = new HashMap<Integer, Object>();
        HashMap r1 = (HashMap)rs1.clone();
        HashMap r2 = (HashMap)rs2.clone();
        ArrayList variables1 = null;
        ArrayList variables2 = null;
        difference.put(0, r1);
        difference.put(1, r2);
        if (rs1.containsKey("boolean") && rs2.containsKey("boolean")) {
            if (rs1.get("boolean").equals(rs2.get("boolean"))) {
                return differenceEmpty;
            }
            return difference;
        }
        r1.replace("result", ((HashMap)r1.get("result")).clone());
        r2.replace("result", ((HashMap)r2.get("result")).clone());
        HashMap result1 = (HashMap)r1.get("result");
        HashMap result2 = (HashMap)r2.get("result");
        if (rs1.containsKey("result") && rs2.containsKey("result") && (((HashMap)rs1.get("result")).containsKey("variables") || ((HashMap)rs2.get("result")).containsKey("variables")) && ((HashMap)rs1.get("result")).containsKey("variables") && ((HashMap)rs2.get("result")).containsKey("variables")) {
            ArrayList variables1Origin = (ArrayList)((HashMap)rs1.get("result")).get("variables");
            ArrayList variables2Origin = (ArrayList)((HashMap)rs2.get("result")).get("variables");
            result1.replace("variables", ((ArrayList)((HashMap)r1.get("result")).get("variables")).clone());
            result2.replace("variables", ((ArrayList)((HashMap)r2.get("result")).get("variables")).clone());
            variables1 = (ArrayList)((HashMap)r1.get("result")).get("variables");
            variables2 = (ArrayList)((HashMap)r2.get("result")).get("variables");
            int variables1Size = variables1Origin.size();
            int variables2Size = variables2Origin.size();
            int max = Integer.max(variables1Size, variables2Size);
            for (i = 0; i < max; ++i) {
                if (i >= variables1Size || i >= variables2Size || !((String)variables1Origin.get(i)).equals(variables2Origin.get(i))) continue;
                variables1.remove(variables1Origin.get(i));
                variables2.remove(variables2Origin.get(i));
            }
            if (variables1.size() == 0) {
                result1.remove("variables");
            }
            if (variables2.size() == 0) {
                result2.remove("variables");
            }
        }
        if (!((HashMap)rs1.get("result")).containsKey("rows") && !((HashMap)rs2.get("result")).containsKey("rows")) {
            return difference;
        }
        if (!((HashMap)rs1.get("result")).containsKey("rows") || !((HashMap)rs2.get("result")).containsKey("rows")) {
            return difference;
        }
        ArrayList rows1Origin = (ArrayList)((HashMap)rs1.get("result")).get("rows");
        ArrayList rows2Origin = (ArrayList)((HashMap)rs2.get("result")).get("rows");
        HashMap rows1 = new HashMap();
        HashMap rows2 = new HashMap();
        int rows1Size = rows1Origin.size();
        int rows2Size = rows2Origin.size();
        int rowsmax = Integer.max(rows1Size, rows2Size);
        for (i = 0; i < rowsmax; ++i) {
            if (i < rows1Size && i < rows2Size) {
                HashMap cells1Origin = (HashMap)rows1Origin.get(i);
                HashMap cells2Origin = (HashMap)rows2Origin.get(i);
                HashMap cells1 = (HashMap)cells1Origin.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                HashMap cells2 = (HashMap)cells2Origin.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                cells1Origin.forEach((k, v) -> {
                    if (v.equals(cells2Origin.get(k))) {
                        cells1.remove(k);
                        cells2.remove(k);
                    }
                });
                cells2Origin.forEach((k, v) -> {
                    if (v.equals(cells1Origin.get(k))) {
                        cells1.remove(k);
                        cells2.remove(k);
                    }
                });
                if (cells1.size() > 0) {
                    rows1.put(i, cells1);
                }
                if (cells2.size() <= 0) continue;
                rows2.put(i, cells2);
                continue;
            }
            if (i >= rows1Size) {
                rows2.put(i, rows2Origin.get(i));
                continue;
            }
            if (i < rows2Size) continue;
            rows1.put(i, rows1Origin.get(i));
        }
        result1.replace("rows", rows1);
        result2.replace("rows", rows2);
        if (rows1.size() == 0) {
            result1.remove("rows");
        }
        if (rows2.size() == 0) {
            result2.remove("rows");
        }
        if (result1.size() == 0) {
            r1.remove("result");
        }
        if (result2.size() == 0) {
            r2.remove("result");
        }
        if (r1.size() == 0 && r2.size() == 0) {
            difference = differenceEmpty;
        }
        return difference;
    }
}

