/*
 * Decompiled with CFR 0.152.
 */
package com.bordercloud.sparql;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;

public abstract class SparqlResultModel
extends AbstractTableModel {
    protected HashMap<String, Object> resultHashMap;
    protected ArrayList<HashMap<String, Object>> rows;
    protected ArrayList<String> variables;

    public HashMap<String, Object> getResultHashMap() {
        return this.resultHashMap;
    }

    @Override
    public int getColumnCount() {
        if (this.variables != null) {
            return this.variables.size();
        }
        return 0;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.variables != null && columnIndex < this.getColumnCount()) {
            return this.variables.get(columnIndex);
        }
        throw new IndexOutOfBoundsException("Invalid range : columnIndex " + columnIndex + " (max " + this.getColumnCount() + ")");
    }

    @Override
    public int getRowCount() {
        if (this.rows != null) {
            return this.rows.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.variables != null && columnIndex < this.getColumnCount() && this.rows != null && rowIndex < this.getRowCount()) {
            return this.rows.get(rowIndex).get(this.variables.get(columnIndex));
        }
        throw new IndexOutOfBoundsException("Invalid range : rowIndex is " + rowIndex + "(max " + this.getRowCount() + ") columnIndex " + columnIndex + "(max " + this.getColumnCount() + ")");
    }

    public ArrayList<HashMap<String, Object>> getRows() {
        return this.rows;
    }

    public ArrayList<String> getVariables() {
        return this.variables;
    }

    public static void printResult(SparqlResultModel sr, int size) {
        for (String string : sr.variables) {
            System.out.print(String.format("%-" + size + "." + size + "s", string) + " | ");
        }
        System.out.print("\n");
        for (HashMap hashMap : sr.rows) {
            for (String variable : sr.variables) {
                System.out.print(String.format("%-" + size + "." + size + "s", hashMap.get(variable)) + " | ");
            }
            System.out.print("\n");
        }
    }
}

