/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.impl.dsl;

import com.botronsoft.cmj.spitools.dsl.ArgumentContainerDescriptor;
import com.botronsoft.cmj.spitools.dsl.ArgumentDescriptor;
import com.botronsoft.cmj.spitools.dsl.ArgumentType;
import com.botronsoft.cmj.spitools.impl.dsl.ReferenceValueType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AbstractArgumentDescriptor<T extends ArgumentDescriptor<?>>
implements ArgumentDescriptor<T> {
    private final String argumentName;
    private final ArgumentContainerDescriptor container;
    private ArgumentType argumentType = null;
    private ReferenceValueType referenceValueType = ReferenceValueType.ID;
    private final Set<String> literalValues = new HashSet<String>();

    public AbstractArgumentDescriptor(String argumentName, ArgumentContainerDescriptor container) {
        this.argumentName = argumentName;
        this.container = container;
    }

    @Override
    public ArgumentContainerDescriptor and() {
        return this.container;
    }

    @Override
    public T ofType(ArgumentType argumentType) {
        this.argumentType = argumentType;
        return this.self();
    }

    @Override
    public T byId() {
        this.referenceValueType = ReferenceValueType.ID;
        return this.self();
    }

    @Override
    public T byName() {
        this.referenceValueType = ReferenceValueType.NAME;
        return this.self();
    }

    @Override
    public T byKey() {
        this.referenceValueType = ReferenceValueType.KEY;
        return this.self();
    }

    @Override
    public T withLiteralValues(String ... literalValues) {
        Collections.addAll(this.literalValues, literalValues);
        return this.self();
    }

    public String getArgumentName() {
        return this.argumentName;
    }

    public ArgumentType getArgumentType() {
        return this.argumentType;
    }

    public ReferenceValueType getReferenceValueType() {
        return this.referenceValueType;
    }

    public Set<String> getLiteralValues() {
        return this.literalValues;
    }

    private T self() {
        return (T)this;
    }
}

