/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.impl.transformation;

import com.botronsoft.cmj.spitools.dsl.ArgumentDescriptor;
import com.botronsoft.cmj.spitools.dsl.ArgumentType;
import com.botronsoft.cmj.spitools.dsl.MultiValueArgumentDescriptor;
import com.botronsoft.cmj.spitools.dsl.SingleValueArgumentDescriptor;
import com.botronsoft.cmj.spitools.impl.JiraManagersService;
import com.botronsoft.cmj.spitools.impl.transformation.ArgumentProcessor;
import com.botronsoft.cmj.spitools.impl.transformation.MultiValueArgumentProcessor;
import com.botronsoft.cmj.spitools.impl.transformation.SingleValueArgumentProcessor;
import com.botronsoft.cmj.spitools.impl.transformation.configuration.Configuration;
import com.botronsoft.cmj.spitools.impl.transformation.configuration.ConfigurationFactory;
import com.botronsoft.cmj.spitools.impl.transformation.parsers.MultiValueArgumentParser;
import com.botronsoft.cmj.spitools.impl.transformation.parsers.SingleValueArgumentParser;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.ArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.FieldArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.FilterArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.GroupArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.IssueLinkTypeArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.IssueTypeArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.PriorityArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.ProjectArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.ProjectRoleArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.QueryArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.RequestTypeArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.ResolutionArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.SecurityLevelArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.StatusArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.UserArgumentTransformer;
import java.util.HashMap;
import java.util.Map;

public class ArgumentProcessorFactory {
    private final Map<ArgumentType, ArgumentTransformer> transformersClassesMap = new HashMap<ArgumentType, ArgumentTransformer>();

    public ArgumentProcessorFactory(JiraManagersService jiraManagersService) {
        this.initializeTransformersMap(jiraManagersService);
    }

    private void initializeTransformersMap(JiraManagersService jiraManagersService) {
        this.transformersClassesMap.put(ArgumentType.FIELD, new FieldArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.USER, new UserArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.GROUP, new GroupArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.STATUS, new StatusArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.ISSUE_TYPE, new IssueTypeArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.ISSUE_LINK_TYPE, new IssueLinkTypeArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.PRIORITY, new PriorityArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.RESOLUTION, new ResolutionArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.PROJECT, new ProjectArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.PROJECT_ROLE, new ProjectRoleArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.SEARCH_REQUEST, new FilterArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.QUERY, new QueryArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.SECURITY_LEVEL, new SecurityLevelArgumentTransformer(jiraManagersService));
        this.transformersClassesMap.put(ArgumentType.REQUEST_TYPE, new RequestTypeArgumentTransformer(jiraManagersService));
    }

    public ArgumentProcessor createProcessor(ArgumentDescriptor descriptor) {
        if (descriptor instanceof SingleValueArgumentDescriptor) {
            return this.createSingleValueProcessor((SingleValueArgumentDescriptor)descriptor);
        }
        if (descriptor instanceof MultiValueArgumentDescriptor) {
            return this.createMultiValueProcessor((MultiValueArgumentDescriptor)descriptor);
        }
        throw new IllegalArgumentException("Unsupported argument descriptor type: " + descriptor);
    }

    private SingleValueArgumentProcessor createSingleValueProcessor(SingleValueArgumentDescriptor descriptor) {
        Configuration configuration = ConfigurationFactory.createConfigurationForSingleValueDescriptor(descriptor);
        return new SingleValueArgumentProcessor(configuration, new SingleValueArgumentParser(), this.getArgumentTransformer(configuration.getArgumentType()));
    }

    private MultiValueArgumentProcessor createMultiValueProcessor(MultiValueArgumentDescriptor descriptor) {
        Configuration configuration = ConfigurationFactory.createConfigurationForMultiValueDescriptor(descriptor);
        return new MultiValueArgumentProcessor(configuration, new MultiValueArgumentParser(), this.getArgumentTransformer(configuration.getArgumentType()));
    }

    private ArgumentTransformer getArgumentTransformer(ArgumentType type) {
        return this.transformersClassesMap.get((Object)type);
    }
}

