/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.impl.transformation;

import com.botronsoft.cmj.spi.configuration.ExportContext;
import com.botronsoft.cmj.spi.configuration.ImportContext;
import com.botronsoft.cmj.spitools.impl.transformation.ArgumentProcessor;
import com.botronsoft.cmj.spitools.impl.transformation.configuration.Configuration;
import com.botronsoft.cmj.spitools.impl.transformation.parsers.MultiValueArgumentParser;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.ArgumentTransformer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

class MultiValueArgumentProcessor
implements ArgumentProcessor {
    private static final Logger log = Logger.getLogger(MultiValueArgumentProcessor.class);
    private final Configuration configuration;
    private final MultiValueArgumentParser multiValueParser;
    private final ArgumentTransformer transformer;

    MultiValueArgumentProcessor(Configuration configuration, MultiValueArgumentParser multiValueParser, ArgumentTransformer transformer) {
        if (!configuration.getSeparator().isPresent()) {
            throw new IllegalArgumentException("No separator for multi-valued argument: " + configuration.getArgumentName());
        }
        this.configuration = configuration;
        this.multiValueParser = multiValueParser;
        this.transformer = transformer;
    }

    @Override
    public String processArgumentForExport(String value, ExportContext exportContext) {
        Optional<List<String>> singleValuesOptional = this.multiValueParser.parse(value, this.configuration);
        if (!singleValuesOptional.isPresent()) {
            log.debug((Object)String.format("Ignoring unparsable value for argument '%s': '%s'", this.configuration.getArgumentName(), value));
            return value;
        }
        List<String> singleValues = singleValuesOptional.get();
        return singleValues.stream().map(singleValue -> this.transformer.transformArgumentForExport((String)singleValue, this.configuration, exportContext.getReferenceCollector())).collect(Collectors.joining(this.configuration.getSeparator().get()));
    }

    @Override
    public String processArgumentForImport(String value, ImportContext importContext) {
        Optional<List<String>> singleValuesOptional = this.multiValueParser.parse(value, this.configuration);
        if (!singleValuesOptional.isPresent()) {
            log.debug((Object)String.format("Ignoring unparsable value for argument '%s': '%s'", this.configuration.getArgumentName(), value));
            return value;
        }
        List<String> singleValues = singleValuesOptional.get();
        return singleValues.stream().map(singleValue -> this.transformer.transformArgumentForImport((String)singleValue, this.configuration, importContext.getReferenceLookup())).collect(Collectors.joining(this.configuration.getSeparator().get()));
    }
}

