/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.impl.transformation;

import com.botronsoft.cmj.spi.configuration.ExportContext;
import com.botronsoft.cmj.spi.configuration.ImportContext;
import com.botronsoft.cmj.spitools.impl.transformation.ArgumentProcessor;
import com.botronsoft.cmj.spitools.impl.transformation.configuration.Configuration;
import com.botronsoft.cmj.spitools.impl.transformation.parsers.SingleValueArgumentParser;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.ArgumentTransformer;
import java.util.Optional;
import org.apache.log4j.Logger;

class SingleValueArgumentProcessor
implements ArgumentProcessor {
    private static final Logger log = Logger.getLogger(SingleValueArgumentProcessor.class);
    private final Configuration configuration;
    private final SingleValueArgumentParser singleValueParser;
    private final ArgumentTransformer transformer;

    SingleValueArgumentProcessor(Configuration configuration, SingleValueArgumentParser singleValueParser, ArgumentTransformer transformer) {
        this.configuration = configuration;
        this.singleValueParser = singleValueParser;
        this.transformer = transformer;
    }

    @Override
    public String processArgumentForExport(String value, ExportContext exportContext) {
        Optional<String> valueOptional = this.singleValueParser.parse(value, this.configuration);
        if (!valueOptional.isPresent()) {
            log.debug((Object)String.format("Ignoring value for argument '%s': '%s'", this.configuration.getArgumentName(), value));
            return value;
        }
        return this.transformer.transformArgumentForExport(value, this.configuration, exportContext.getReferenceCollector());
    }

    @Override
    public String processArgumentForImport(String value, ImportContext importContext) {
        Optional<String> valueOptional = this.singleValueParser.parse(value, this.configuration);
        if (!valueOptional.isPresent()) {
            log.debug((Object)String.format("Ignoring value for argument '%s': '%s'", this.configuration.getArgumentName(), value));
            return value;
        }
        return this.transformer.transformArgumentForImport(value, this.configuration, importContext.getReferenceLookup());
    }
}

