/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.impl.transformation.configuration;

import com.botronsoft.cmj.spitools.dsl.MultiValueArgumentDescriptor;
import com.botronsoft.cmj.spitools.dsl.SingleValueArgumentDescriptor;
import com.botronsoft.cmj.spitools.impl.dsl.MultiValueArgumentDescriptorImpl;
import com.botronsoft.cmj.spitools.impl.dsl.ReferenceValueType;
import com.botronsoft.cmj.spitools.impl.dsl.SingleValueArgumentDescriptorImpl;
import com.botronsoft.cmj.spitools.impl.transformation.configuration.Configuration;
import com.botronsoft.cmj.spitools.impl.transformation.configuration.ReferenceType;
import java.util.Optional;

public class ConfigurationFactory {
    private ConfigurationFactory() {
    }

    public static Configuration createConfigurationForSingleValueDescriptor(SingleValueArgumentDescriptor argumentDescriptor) {
        SingleValueArgumentDescriptorImpl descriptorImpl = (SingleValueArgumentDescriptorImpl)argumentDescriptor;
        return new Configuration(descriptorImpl.getArgumentName(), descriptorImpl.getArgumentType(), ConfigurationFactory.toReferenceType(descriptorImpl.getReferenceValueType()), descriptorImpl.getLiteralValues());
    }

    public static Configuration createConfigurationForMultiValueDescriptor(MultiValueArgumentDescriptor argumentDescriptor) {
        MultiValueArgumentDescriptorImpl descriptorImpl = (MultiValueArgumentDescriptorImpl)argumentDescriptor;
        return new Configuration(descriptorImpl.getArgumentName(), descriptorImpl.getArgumentType(), ConfigurationFactory.toReferenceType(descriptorImpl.getReferenceValueType()), descriptorImpl.getLiteralValues(), Optional.ofNullable(descriptorImpl.getSeparator()));
    }

    private static ReferenceType toReferenceType(ReferenceValueType referenceValueType) {
        switch (referenceValueType) {
            case ID: {
                return ReferenceType.BY_ID;
            }
            case NAME: {
                return ReferenceType.BY_NAME;
            }
            case KEY: {
                return ReferenceType.BY_KEY;
            }
        }
        throw new IllegalArgumentException("Unknown reference value type: " + (Object)((Object)referenceValueType));
    }
}

