/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.impl.transformation.parsers;

import com.botronsoft.cmj.spitools.impl.transformation.configuration.Configuration;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public class MultiValueArgumentParser {
    public Optional<List<String>> parse(String value, Configuration configuration) {
        if (value == null || configuration.getLiteralValues().contains(value) || !configuration.getSeparator().isPresent()) {
            return Optional.empty();
        }
        ArrayList result = Lists.newArrayList();
        if (!value.isEmpty()) {
            String separator = configuration.getSeparator().get();
            String regex = Pattern.quote(separator) + "(?x)                      (?=                         (                           [^\"]*                    \"                        [^\"]*                    \"                      )*                        [^\"]*                    $                       )                         ";
            for (String singleValue : value.split(regex)) {
                result.add(singleValue.trim().replaceAll("\"", ""));
            }
        }
        return Optional.of(result);
    }
}

