/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.impl.transformation.transformers;

import com.botronsoft.cmj.spi.configuration.ConfigurationReferenceCollector;
import com.botronsoft.cmj.spi.configuration.ConfigurationReferenceLookup;
import com.botronsoft.cmj.spitools.impl.JiraManagersService;
import com.botronsoft.cmj.spitools.impl.transformation.configuration.Configuration;
import com.botronsoft.cmj.spitools.impl.transformation.configuration.ReferenceType;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.ArgumentTransformer;
import java.util.Collection;
import java.util.Optional;
import org.apache.log4j.Logger;

public abstract class AbstractArgumentTransformer<T>
implements ArgumentTransformer {
    private static final Logger log = Logger.getLogger(AbstractArgumentTransformer.class);
    protected final JiraManagersService jiraManagersService;

    protected AbstractArgumentTransformer(JiraManagersService jiraManagersService) {
        this.jiraManagersService = jiraManagersService;
    }

    @Override
    public final String transformArgumentForExport(String value, Configuration configuration, ConfigurationReferenceCollector referenceCollector) {
        Optional<T> reference = this.findReference(value, configuration);
        if (!reference.isPresent()) {
            log.debug((Object)String.format("Unable to extract reference from value '%s' for argument '%s'", configuration.getArgumentName(), value));
        } else {
            this.collectReference(value, reference.get(), referenceCollector);
            log.debug((Object)String.format("Successfully extracted reference from value '%s' for argument '%s'", configuration.getArgumentName(), value));
        }
        return value;
    }

    @Override
    public final String transformArgumentForImport(String value, Configuration configuration, ConfigurationReferenceLookup referenceLookup) {
        Optional<T> resolvedReference = this.lookupReference(value, referenceLookup);
        if (!resolvedReference.isPresent()) {
            log.debug((Object)String.format("Unable to resolve reference from value '%s' for argument '%s'", value, configuration.getArgumentName()));
            return value;
        }
        log.debug((Object)String.format("Successfully resolved reference from value '%s' for argument '%s'", value, configuration.getArgumentName()));
        if (configuration.getReferenceType() == ReferenceType.BY_ID) {
            return this.getReferenceId(resolvedReference.get());
        }
        return this.getValueFromReference(configuration, resolvedReference.get());
    }

    private Optional<T> findReference(String value, Configuration configuration) {
        switch (configuration.getReferenceType()) {
            case BY_ID: {
                return Optional.ofNullable(this.findReferenceById(value));
            }
            case BY_NAME: {
                return Optional.ofNullable(this.findReferenceByName(value));
            }
            case BY_KEY: {
                return Optional.ofNullable(this.findReferenceByKey(value));
            }
        }
        throw new IllegalArgumentException("Unknown reference type: " + (Object)((Object)configuration.getReferenceType()));
    }

    protected abstract T findReferenceById(String var1);

    protected abstract T findReferenceByName(String var1);

    protected T findReferenceByKey(String value) {
        return this.findReferenceById(value);
    }

    protected abstract void collectReference(String var1, T var2, ConfigurationReferenceCollector var3);

    private String getValueFromReference(Configuration configuration, T resolvedReference) {
        switch (configuration.getReferenceType()) {
            case BY_ID: {
                return this.getReferenceId(resolvedReference);
            }
            case BY_NAME: {
                return this.getReferenceName(resolvedReference);
            }
            case BY_KEY: {
                return this.getReferenceKey(resolvedReference);
            }
        }
        throw new IllegalArgumentException("Unknown reference type: " + (Object)((Object)configuration.getReferenceType()));
    }

    protected abstract String getReferenceId(T var1);

    protected abstract String getReferenceName(T var1);

    protected String getReferenceKey(T reference) {
        return this.getReferenceId(reference);
    }

    protected abstract Optional<T> lookupReference(String var1, ConfigurationReferenceLookup var2);

    protected T findFirstMatch(Collection<T> matches, String objectName, String objectType) {
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            log.debug((Object)String.format("There is more than one reference with name %s of type '%s'.", objectName, objectType));
        }
        return matches.iterator().next();
    }
}

