/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.impl.transformation.transformers;

import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.botronsoft.cmj.spi.configuration.ConfigurationReferenceCollector;
import com.botronsoft.cmj.spi.configuration.ConfigurationReferenceLookup;
import com.botronsoft.cmj.spitools.impl.JiraManagersService;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.AbstractArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.ArgumentTransformer;
import java.util.ArrayList;
import java.util.Optional;

public class IssueLinkTypeArgumentTransformer
extends AbstractArgumentTransformer<IssueLinkType>
implements ArgumentTransformer {
    public IssueLinkTypeArgumentTransformer(JiraManagersService jiraManagersService) {
        super(jiraManagersService);
    }

    @Override
    protected IssueLinkType findReferenceById(String value) {
        return this.jiraManagersService.getIssueLinkTypeManager().getIssueLinkType(Long.valueOf(value));
    }

    @Override
    protected IssueLinkType findReferenceByName(String value) {
        IssueLinkTypeManager issueLinkTypeManager = this.jiraManagersService.getIssueLinkTypeManager();
        ArrayList issueLinkTypes = new ArrayList(issueLinkTypeManager.getIssueLinkTypesByName(value));
        return (IssueLinkType)this.findFirstMatch(issueLinkTypes, value, "issue link type");
    }

    @Override
    protected void collectReference(String key, IssueLinkType reference, ConfigurationReferenceCollector referenceCollector) {
        referenceCollector.collectIssueLinkType(key, reference);
    }

    @Override
    protected String getReferenceId(IssueLinkType issueLinkType) {
        return String.valueOf(issueLinkType.getId());
    }

    @Override
    protected String getReferenceName(IssueLinkType issueLinkType) {
        return issueLinkType.getName();
    }

    @Override
    protected Optional<IssueLinkType> lookupReference(String key, ConfigurationReferenceLookup referenceLookup) {
        return referenceLookup.lookupIssueLinkType(key);
    }
}

