/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.impl.transformation.transformers;

import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.query.Query;
import com.botronsoft.cmj.spi.configuration.ConfigurationReferenceCollector;
import com.botronsoft.cmj.spi.configuration.ConfigurationReferenceLookup;
import com.botronsoft.cmj.spitools.impl.JiraManagersService;
import com.botronsoft.cmj.spitools.impl.transformation.configuration.Configuration;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.AbstractArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.ArgumentTransformer;
import java.util.Optional;
import org.apache.log4j.Logger;

public class QueryArgumentTransformer
implements ArgumentTransformer {
    private static final Logger log = Logger.getLogger(AbstractArgumentTransformer.class);
    private final JiraManagersService jiraManagersService;

    public QueryArgumentTransformer(JiraManagersService jiraManagersService) {
        this.jiraManagersService = jiraManagersService;
    }

    @Override
    public String transformArgumentForExport(String value, Configuration configuration, ConfigurationReferenceCollector referenceCollector) {
        Query parsedQuery;
        try {
            parsedQuery = this.jiraManagersService.getJqlQueryParser().parseQuery(value);
        }
        catch (JqlParseException e) {
            log.debug((Object)("Unable to parse JQL query: " + value), (Throwable)e);
            return value;
        }
        referenceCollector.collectQuery(value, parsedQuery);
        log.debug((Object)String.format("Successfully extracted query from value '%s' for argument '%s'", value, configuration.getArgumentName()));
        return value;
    }

    @Override
    public String transformArgumentForImport(String value, Configuration configuration, ConfigurationReferenceLookup referenceLookup) {
        Optional query = referenceLookup.lookupQuery(value);
        if (!query.isPresent()) {
            log.debug((Object)String.format("Unable to resolve query from value '%s' for argument '%s'", value, configuration.getArgumentName()));
            return value;
        }
        log.debug((Object)String.format("Successfully resolved query from value '%s' for argument '%s'", value, configuration.getArgumentName()));
        JqlStringSupport jqlStringSupport = this.jiraManagersService.getJqlStringSupport();
        return jqlStringSupport.generateJqlString((Query)query.get());
    }
}

