/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.impl.transformation.transformers;

import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.botronsoft.cmj.spi.configuration.ConfigurationReferenceCollector;
import com.botronsoft.cmj.spi.configuration.ConfigurationReferenceLookup;
import com.botronsoft.cmj.spitools.impl.JiraManagersService;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.AbstractArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.ArgumentTransformer;
import java.util.Collection;
import java.util.Optional;

public class SecurityLevelArgumentTransformer
extends AbstractArgumentTransformer<IssueSecurityLevel>
implements ArgumentTransformer {
    public SecurityLevelArgumentTransformer(JiraManagersService jiraManagersService) {
        super(jiraManagersService);
    }

    @Override
    protected IssueSecurityLevel findReferenceById(String value) {
        return this.jiraManagersService.getIssueSecurityLevelManager().getSecurityLevel(Long.valueOf(value).longValue());
    }

    @Override
    protected IssueSecurityLevel findReferenceByName(String value) {
        Collection securityLevels = this.jiraManagersService.getIssueSecurityLevelManager().getIssueSecurityLevelsByName(value);
        return (IssueSecurityLevel)this.findFirstMatch(securityLevels, value, "issue security level");
    }

    @Override
    protected void collectReference(String key, IssueSecurityLevel reference, ConfigurationReferenceCollector referenceCollector) {
        referenceCollector.collectSecurityLevel(key, reference);
    }

    @Override
    protected String getReferenceId(IssueSecurityLevel reference) {
        return String.valueOf(reference.getId());
    }

    @Override
    protected String getReferenceName(IssueSecurityLevel reference) {
        return reference.getName();
    }

    @Override
    protected Optional<IssueSecurityLevel> lookupReference(String key, ConfigurationReferenceLookup referenceLookup) {
        return referenceLookup.lookupSecurityLevel(key);
    }
}

