/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.impl.transformation.transformers;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.Status;
import com.botronsoft.cmj.spi.configuration.ConfigurationReferenceCollector;
import com.botronsoft.cmj.spi.configuration.ConfigurationReferenceLookup;
import com.botronsoft.cmj.spitools.impl.JiraManagersService;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.AbstractArgumentTransformer;
import com.botronsoft.cmj.spitools.impl.transformation.transformers.ArgumentTransformer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class StatusArgumentTransformer
extends AbstractArgumentTransformer<Status>
implements ArgumentTransformer {
    public StatusArgumentTransformer(JiraManagersService jiraManagersService) {
        super(jiraManagersService);
    }

    @Override
    protected Status findReferenceById(String value) {
        return this.jiraManagersService.getStatusManager().getStatus(value);
    }

    @Override
    protected Status findReferenceByName(String value) {
        StatusManager statusManager = this.jiraManagersService.getStatusManager();
        List statuses = statusManager.getStatuses().stream().filter(st -> st.getName().equalsIgnoreCase(value)).collect(Collectors.toList());
        return (Status)this.findFirstMatch(statuses, value, "status");
    }

    @Override
    protected void collectReference(String key, Status status, ConfigurationReferenceCollector referenceCollector) {
        referenceCollector.collectStatus(key, status);
    }

    @Override
    protected String getReferenceId(Status status) {
        return String.valueOf(status.getId());
    }

    @Override
    protected String getReferenceName(Status status) {
        return status.getName();
    }

    @Override
    protected Optional<Status> lookupReference(String key, ConfigurationReferenceLookup referenceLookup) {
        return referenceLookup.lookupStatus(key);
    }
}

