/*
 * Decompiled with CFR 0.152.
 */
package com.botronsoft.cmj.spitools.workflow;

import com.botronsoft.cmj.spi.annotations.PublicApi;
import com.botronsoft.cmj.spi.configuration.ExportContext;
import com.botronsoft.cmj.spi.configuration.ImportContext;
import com.botronsoft.cmj.spi.configuration.workflow.WorkflowParticipantHandler;
import com.botronsoft.cmj.spitools.dsl.ArgumentContainerDescriptor;
import com.botronsoft.cmj.spitools.dsl.ArgumentDescriptor;
import com.botronsoft.cmj.spitools.dsl.ArgumentType;
import com.botronsoft.cmj.spitools.impl.JiraManagersService;
import com.botronsoft.cmj.spitools.impl.JiraManagersServiceImpl;
import com.botronsoft.cmj.spitools.impl.dsl.AbstractArgumentDescriptor;
import com.botronsoft.cmj.spitools.impl.dsl.ArgumentContainerDescriptorImpl;
import com.botronsoft.cmj.spitools.impl.dsl.ReferenceValueType;
import com.botronsoft.cmj.spitools.impl.transformation.ArgumentProcessor;
import com.botronsoft.cmj.spitools.impl.transformation.ArgumentProcessorFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;

@PublicApi
public abstract class AbstractWorkflowParticipantHandler
implements WorkflowParticipantHandler {
    private static final Logger log = Logger.getLogger(AbstractWorkflowParticipantHandler.class);
    private final ArgumentProcessorFactory argumentProcessorFactory;
    private final Map<String, ArgumentContainerDescriptor> argumentContainerDescriptorsMap = new HashMap<String, ArgumentContainerDescriptor>();

    public AbstractWorkflowParticipantHandler() {
        this(new JiraManagersServiceImpl());
    }

    AbstractWorkflowParticipantHandler(JiraManagersService jiraManagersService) {
        this.argumentProcessorFactory = new ArgumentProcessorFactory(jiraManagersService);
        this.describeArguments();
        this.validateDescriptors();
    }

    public Map<String, String> transformArgumentsForExport(String className, Map<String, String> args, ExportContext exportContext) {
        return this.transformArguments(className, args, (value, argumentProcessor) -> argumentProcessor.processArgumentForExport(value, exportContext));
    }

    public Map<String, String> transformArgumentsForImport(String className, Map<String, String> args, ImportContext importContext) {
        return this.transformArguments(className, args, (value, argumentProcessor) -> argumentProcessor.processArgumentForImport(value, importContext));
    }

    protected abstract void describeArguments();

    protected void handleError(String className, String argumentName, Throwable t) {
        log.error((Object)("Failed to transform argument with name " + argumentName + " belonging to participant with class name " + className + "!"), t);
    }

    protected String transformUnhandledArgumentForExport(String className, String argName, String argValue, ExportContext exportContext) {
        return argValue;
    }

    protected String transformUnhandledArgumentForImport(String className, String argName, String argValue, ImportContext importContext) {
        return argValue;
    }

    protected final ArgumentContainerDescriptor condition(String className) {
        return this.getOrCreateArgumentDescriptor(className);
    }

    protected final ArgumentContainerDescriptor validator(String className) {
        return this.getOrCreateArgumentDescriptor(className);
    }

    protected final ArgumentContainerDescriptor postFunction(String className) {
        return this.getOrCreateArgumentDescriptor(className);
    }

    private void validateDescriptors() {
        for (Map.Entry<String, ArgumentContainerDescriptor> descriptorEntry : this.argumentContainerDescriptorsMap.entrySet()) {
            Map<String, ArgumentDescriptor<?>> argumentDescriptors = ((ArgumentContainerDescriptorImpl)descriptorEntry.getValue()).getArgumentDescriptors();
            Iterator<Map.Entry<String, ArgumentDescriptor<?>>> iterator = argumentDescriptors.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ArgumentDescriptor<?>> argumentEntry = iterator.next();
                AbstractArgumentDescriptor descriptor = (AbstractArgumentDescriptor)argumentEntry.getValue();
                if (!descriptor.getArgumentType().equals((Object)ArgumentType.REQUEST_TYPE) || !descriptor.getReferenceValueType().equals((Object)ReferenceValueType.NAME)) continue;
                log.warn((Object)"Request types can only be referred by id.");
                iterator.remove();
            }
        }
    }

    private ArgumentContainerDescriptor getOrCreateArgumentDescriptor(String className) {
        ArgumentContainerDescriptor argumentContainerDescriptor = this.argumentContainerDescriptorsMap.get(className);
        if (argumentContainerDescriptor == null) {
            argumentContainerDescriptor = new ArgumentContainerDescriptorImpl();
            this.argumentContainerDescriptorsMap.put(className, argumentContainerDescriptor);
        }
        return argumentContainerDescriptor;
    }

    private Map<String, String> transformArguments(String className, Map<String, String> args, ArgumentProcessorInvoker argumentProcessorInvoker) {
        LinkedHashMap<String, String> transformedArgs = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : args.entrySet()) {
            try {
                ArgumentProcessor argumentProcessor = this.createArgumentHandler(className, entry.getKey());
                String transformedValue = argumentProcessorInvoker.invoke(entry.getValue(), argumentProcessor);
                transformedArgs.put(entry.getKey(), transformedValue);
            }
            catch (Throwable t) {
                this.handleError(className, entry.getKey(), t);
                transformedArgs.put(entry.getKey(), entry.getValue());
            }
        }
        return transformedArgs;
    }

    private ArgumentProcessor createArgumentHandler(String className, String argName) {
        Optional<ArgumentDescriptor<?>> argumentDescriptorOptional;
        ArgumentContainerDescriptor argumentContainerDescriptor = this.argumentContainerDescriptorsMap.get(className);
        if (argumentContainerDescriptor != null && (argumentDescriptorOptional = ((ArgumentContainerDescriptorImpl)argumentContainerDescriptor).getArgumentDescriptor(argName)).isPresent()) {
            return this.argumentProcessorFactory.createProcessor(argumentDescriptorOptional.get());
        }
        return new DefaultArgumentProcessor(className, argName);
    }

    private final class DefaultArgumentProcessor
    implements ArgumentProcessor {
        private final String className;
        private final String argName;

        private DefaultArgumentProcessor(String className, String argName) {
            this.className = className;
            this.argName = argName;
        }

        @Override
        public String processArgumentForExport(String value, ExportContext exportContext) {
            return AbstractWorkflowParticipantHandler.this.transformUnhandledArgumentForExport(this.className, this.argName, value, exportContext);
        }

        @Override
        public String processArgumentForImport(String value, ImportContext importContext) {
            return AbstractWorkflowParticipantHandler.this.transformUnhandledArgumentForImport(this.className, this.argName, value, importContext);
        }
    }

    private static interface ArgumentProcessorInvoker {
        public String invoke(String var1, ArgumentProcessor var2);
    }
}

