/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxUser;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class BoxCollaboration
extends BoxResource {
    private static final URLTemplate COLLABORATIONS_URL_TEMPLATE = new URLTemplate("collaborations");
    private static final URLTemplate PENDING_COLLABORATIONS_URL = new URLTemplate("collaborations?status=pending");
    private static final URLTemplate COLLABORATION_URL_TEMPLATE = new URLTemplate("collaborations/%s");

    public BoxCollaboration(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Collection<Info> getPendingCollaborations(BoxAPIConnection api) {
        URL url = PENDING_COLLABORATIONS_URL.build(api.getBaseURL(), new Object[0]);
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        int entriesCount = responseJSON.get("total_count").asInt();
        ArrayList<Info> collaborations = new ArrayList<Info>(entriesCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue entry : entries) {
            BoxCollaboration collaboration;
            JsonObject entryObject = entry.asObject();
            BoxCollaboration boxCollaboration = collaboration = new BoxCollaboration(api, entryObject.get("id").asString());
            boxCollaboration.getClass();
            Info info = boxCollaboration.new Info(entryObject);
            collaborations.add(info);
        }
        return collaborations;
    }

    public Info getInfo() {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATIONS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        return new Info(jsonObject);
    }

    public void updateInfo(Info info) {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATION_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(api, url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        info.update(jsonObject);
    }

    public void delete() {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATION_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public static enum Role {
        EDITOR("editor"),
        VIEWER("viewer"),
        PREVIEWER("previewer"),
        UPLOADER("uploader"),
        PREVIEWER_UPLOADER("previewer uploader"),
        VIEWER_UPLOADER("viewer uploader"),
        CO_OWNER("co-owner"),
        OWNER("owner");

        private final String jsonValue;

        private Role(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Role fromJSONString(String jsonValue) {
            switch (jsonValue) {
                case "editor": {
                    return EDITOR;
                }
                case "viewer": {
                    return VIEWER;
                }
                case "previewer": {
                    return PREVIEWER;
                }
                case "uploader": {
                    return UPLOADER;
                }
                case "previewer uploader": {
                    return PREVIEWER_UPLOADER;
                }
                case "viewer uploader": {
                    return VIEWER_UPLOADER;
                }
                case "co-owner": {
                    return CO_OWNER;
                }
                case "owner": {
                    return OWNER;
                }
            }
            throw new IllegalArgumentException("The provided JSON value isn't a valid Role.");
        }

        String toJSONString() {
            return this.jsonValue;
        }
    }

    public static enum Status {
        ACCEPTED,
        PENDING,
        REJECTED;

    }

    public class Info
    extends BoxResource.Info {
        private BoxUser.Info createdBy;
        private Date createdAt;
        private Date modifiedAt;
        private Date expiresAt;
        private Status status;
        private BoxCollaborator.Info accessibleBy;
        private Role role;
        private Date acknowledgedAt;
        private BoxFolder.Info item;

        public Info() {
            super(BoxCollaboration.this);
        }

        public Info(String json) {
            super((BoxResource)BoxCollaboration.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxCollaboration.this, jsonObject);
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        public Date getExpiresAt() {
            return this.expiresAt;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
            this.addPendingChange("status", status.name().toLowerCase());
        }

        public BoxCollaborator.Info getAccessibleBy() {
            return this.accessibleBy;
        }

        public Role getRole() {
            return this.role;
        }

        public void setRole(Role role) {
            this.role = role;
            this.addPendingChange("role", role.toJSONString());
        }

        public Date getAcknowledgedAt() {
            return this.acknowledgedAt;
        }

        public BoxFolder.Info getItem() {
            return this.item;
        }

        @Override
        public BoxCollaboration getResource() {
            return BoxCollaboration.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            block27: {
                super.parseJSONMember(member);
                String memberName = member.getName();
                JsonValue value = member.getValue();
                try {
                    switch (memberName) {
                        case "created_by": {
                            JsonObject userJSON = value.asObject();
                            if (this.createdBy == null) {
                                BoxUser user;
                                String userID = userJSON.get("id").asString();
                                BoxUser boxUser = user = new BoxUser(BoxCollaboration.this.getAPI(), userID);
                                boxUser.getClass();
                                this.createdBy = new BoxUser.Info(boxUser, userJSON);
                                break;
                            }
                            this.createdBy.update(userJSON);
                            break;
                        }
                        case "created_at": {
                            this.createdAt = BoxDateFormat.parse(value.asString());
                            break;
                        }
                        case "modified_at": {
                            this.modifiedAt = BoxDateFormat.parse(value.asString());
                            break;
                        }
                        case "expires_at": {
                            this.expiresAt = BoxDateFormat.parse(value.asString());
                            break;
                        }
                        case "status": {
                            String statusString = value.asString().toUpperCase();
                            this.status = Status.valueOf(statusString);
                            break;
                        }
                        case "accessible_by": {
                            JsonObject userJSON = value.asObject();
                            if (this.accessibleBy == null) {
                                BoxUser user;
                                String userID = userJSON.get("id").asString();
                                BoxUser boxUser = user = new BoxUser(BoxCollaboration.this.getAPI(), userID);
                                boxUser.getClass();
                                BoxUser.Info userInfo = new BoxUser.Info(boxUser, userJSON);
                                this.accessibleBy = userInfo;
                                break;
                            }
                            this.accessibleBy.update(userJSON);
                            break;
                        }
                        case "role": {
                            this.role = Role.fromJSONString(value.asString());
                            break;
                        }
                        case "acknowledged_at": {
                            this.acknowledgedAt = BoxDateFormat.parse(value.asString());
                            break;
                        }
                        case "item": {
                            JsonObject folderJSON = value.asObject();
                            if (this.item == null) {
                                BoxFolder folder;
                                String folderID = folderJSON.get("id").asString();
                                BoxFolder boxFolder = folder = new BoxFolder(BoxCollaboration.this.getAPI(), folderID);
                                boxFolder.getClass();
                                this.item = new BoxFolder.Info(boxFolder, folderJSON);
                                break;
                            }
                            this.item.update(folderJSON);
                            break;
                        }
                    }
                }
                catch (ParseException e) {
                    if ($assertionsDisabled) break block27;
                    throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
                }
            }
        }
    }
}

