/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxUser;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Pattern;

public class BoxComment
extends BoxResource {
    private static final Pattern MENTION_REGEX = Pattern.compile("@\\[.+:.+\\]");
    private static final URLTemplate ADD_COMMENT_URL_TEMPLATE = new URLTemplate("comments");
    private static final URLTemplate COMMENT_URL_TEMPLATE = new URLTemplate("comments/%s");

    public BoxComment(BoxAPIConnection api, String id) {
        super(api, id);
    }

    static boolean messageContainsMention(String message) {
        return MENTION_REGEX.matcher(message).find();
    }

    public Info getInfo() {
        URL url = COMMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonResponse = JsonObject.readFrom((String)response.getJSON());
        return new Info(jsonResponse);
    }

    public Info changeMessage(String newMessage) {
        Info newInfo = new Info();
        newInfo.setMessage(newMessage);
        URL url = COMMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(newInfo.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonResponse = JsonObject.readFrom((String)response.getJSON());
        return new Info(jsonResponse);
    }

    public Info reply(String message) {
        BoxComment addedComment;
        JsonObject itemJSON = new JsonObject();
        itemJSON.add("type", "comment");
        itemJSON.add("id", this.getID());
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("item", (JsonValue)itemJSON);
        if (BoxComment.messageContainsMention(message)) {
            requestJSON.add("tagged_message", message);
        } else {
            requestJSON.add("message", message);
        }
        URL url = ADD_COMMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxComment boxComment = addedComment = new BoxComment(this.getAPI(), responseJSON.get("id").asString());
        boxComment.getClass();
        return boxComment.new Info(responseJSON);
    }

    public void delete() {
        URL url = COMMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public class Info
    extends BoxResource.Info {
        private boolean isReplyComment;
        private String message;
        private String taggedMessage;
        private BoxUser.Info createdBy;
        private Date createdAt;
        private BoxResource.Info item;
        private BoxUser.Info modifiedBy;

        public Info() {
            super(BoxComment.this);
        }

        public Info(String json) {
            super((BoxResource)BoxComment.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxComment.this, jsonObject);
        }

        public boolean getIsReplyComment() {
            return this.isReplyComment;
        }

        public String getMessage() {
            if (this.taggedMessage != null) {
                return this.taggedMessage;
            }
            return this.message;
        }

        public void setMessage(String message) {
            if (BoxComment.messageContainsMention(message)) {
                this.taggedMessage = message;
                this.addPendingChange("tagged_message", message);
                this.removePendingChange("message");
            } else {
                this.message = message;
                this.addPendingChange("message", message);
                this.removePendingChange("tagged_message");
            }
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public BoxResource.Info getItem() {
            return this.item;
        }

        public BoxUser.Info getModifiedBy() {
            return this.modifiedBy;
        }

        @Override
        public BoxComment getResource() {
            return BoxComment.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            block22: {
                super.parseJSONMember(member);
                try {
                    String memberName = member.getName();
                    JsonValue value = member.getValue();
                    switch (memberName) {
                        case "is_reply_comment": {
                            this.isReplyComment = value.asBoolean();
                            break;
                        }
                        case "message": {
                            this.message = value.asString();
                            break;
                        }
                        case "tagged_message": {
                            this.taggedMessage = value.asString();
                            break;
                        }
                        case "created_by": {
                            JsonObject userJSON = value.asObject();
                            if (this.createdBy == null) {
                                BoxUser user;
                                String userID = userJSON.get("id").asString();
                                BoxUser boxUser = user = new BoxUser(BoxComment.this.getAPI(), userID);
                                boxUser.getClass();
                                this.createdBy = new BoxUser.Info(boxUser, userJSON);
                                break;
                            }
                            this.createdBy.update(userJSON);
                            break;
                        }
                        case "created_at": {
                            this.createdAt = BoxDateFormat.parse(value.asString());
                            break;
                        }
                        case "item": {
                            this.parseItem(value);
                            break;
                        }
                        case "modified_by": {
                            JsonObject userJSON = value.asObject();
                            if (this.modifiedBy == null) {
                                BoxUser user;
                                String userID = userJSON.get("id").asString();
                                BoxUser boxUser = user = new BoxUser(BoxComment.this.getAPI(), userID);
                                boxUser.getClass();
                                this.modifiedBy = new BoxUser.Info(boxUser, userJSON);
                                break;
                            }
                            this.modifiedBy.update(userJSON);
                            break;
                        }
                    }
                }
                catch (ParseException e) {
                    if ($assertionsDisabled) break block22;
                    throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
                }
            }
        }

        private void parseItem(JsonValue value) {
            JsonObject itemJSON = value.asObject();
            String itemType = itemJSON.get("type").asString();
            if (itemType.equals("file")) {
                this.updateItemAsFile(itemJSON);
            } else if (itemType.equals("comment")) {
                this.updateItemAsComment(itemJSON);
            }
        }

        private void updateItemAsFile(JsonObject itemJSON) {
            String itemID = itemJSON.get("id").asString();
            if (this.item != null && this.item instanceof BoxFile.Info && this.item.getID().equals(itemID)) {
                this.item.update(itemJSON);
            } else {
                BoxFile file;
                BoxFile boxFile = file = new BoxFile(BoxComment.this.getAPI(), itemID);
                boxFile.getClass();
                this.item = new BoxFile.Info(boxFile, itemJSON);
            }
        }

        private void updateItemAsComment(JsonObject itemJSON) {
            String itemType = itemJSON.get("type").asString();
            String itemID = itemJSON.get("id").asString();
            if (this.item != null && this.item instanceof Info && this.item.getID().equals(itemID)) {
                this.item.update(itemJSON);
            } else {
                BoxComment comment;
                BoxComment boxComment = comment = new BoxComment(BoxComment.this.getAPI(), itemID);
                boxComment.getClass();
                this.item = boxComment.new Info(itemJSON);
            }
        }
    }
}

