/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxGroupIterator;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import java.net.URL;
import java.util.Iterator;

public class BoxGroup
extends BoxCollaborator {
    private static final URLTemplate GROUPS_URL_TEMPLATE = new URLTemplate("groups");
    private static final URLTemplate GROUP_URL_TEMPLATE = new URLTemplate("groups/%s");

    public BoxGroup(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createGroup(BoxAPIConnection api, String name) {
        BoxGroup group;
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("name", name);
        URL url = GROUPS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "GET");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxGroup boxGroup = group = new BoxGroup(api, responseJSON.get("id").asString());
        boxGroup.getClass();
        return boxGroup.new Info(responseJSON);
    }

    public static Iterable<Info> getAllGroups(final BoxAPIConnection api) {
        return new Iterable<Info>(){

            @Override
            public Iterator<Info> iterator() {
                URL url = GROUPS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
                return new BoxGroupIterator(api, url);
            }
        };
    }

    public void delete() {
        URL url = GROUP_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public class Info
    extends BoxCollaborator.Info {
        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxGroup getResource() {
            return BoxGroup.this;
        }
    }
}

