/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.ProgressListener;
import java.io.IOException;
import java.io.OutputStream;

class ProgressOutputStream
extends OutputStream {
    private final OutputStream stream;
    private final ProgressListener listener;
    private long total;
    private long totalWritten;
    private int progress;

    public ProgressOutputStream(OutputStream stream, ProgressListener listener, long total) {
        this.stream = stream;
        this.listener = listener;
        this.total = total;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.stream.write(b);
        this.totalWritten += (long)b.length;
        this.listener.onProgressChanged(this.totalWritten, this.total);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
        this.totalWritten = len < b.length ? (this.totalWritten += (long)len) : (this.totalWritten += (long)b.length);
        this.listener.onProgressChanged(this.totalWritten, this.total);
    }

    @Override
    public void write(int b) throws IOException {
        this.stream.write(b);
        ++this.totalWritten;
        this.listener.onProgressChanged(this.totalWritten, this.total);
    }
}

