/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnectionListener;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.RequestInterceptor;
import com.eclipsesource.json.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BoxAPIConnection {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    private static final String TOKEN_URL_STRING = "https://www.box.com/api/oauth2/token";
    private static final String DEFAULT_BASE_URL = "https://api.box.com/2.0/";
    private static final String DEFAULT_BASE_UPLOAD_URL = "https://upload.box.com/api/2.0/";
    private static final long REFRESH_EPSILON = 60000L;
    private final String clientID;
    private final String clientSecret;
    private final ReadWriteLock refreshLock;
    private volatile long lastRefresh;
    private volatile long expires;
    private String userAgent;
    private String accessToken;
    private String refreshToken;
    private String tokenURL;
    private String baseURL;
    private String baseUploadURL;
    private boolean autoRefresh;
    private int maxRequestAttempts;
    private List<BoxAPIConnectionListener> listeners;
    private RequestInterceptor interceptor;

    public BoxAPIConnection(String accessToken) {
        this(null, null, accessToken, null);
    }

    public BoxAPIConnection(String clientID, String clientSecret, String accessToken, String refreshToken) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenURL = TOKEN_URL_STRING;
        this.baseURL = DEFAULT_BASE_URL;
        this.baseUploadURL = DEFAULT_BASE_UPLOAD_URL;
        this.autoRefresh = true;
        this.maxRequestAttempts = 3;
        this.refreshLock = new ReentrantReadWriteLock();
        this.userAgent = "Box Java SDK v0.6.0";
        this.listeners = new ArrayList<BoxAPIConnectionListener>();
    }

    public BoxAPIConnection(String clientID, String clientSecret, String authCode) {
        this(clientID, clientSecret, null, null);
        this.authenticate(authCode);
    }

    public BoxAPIConnection(String clientID, String clientSecret) {
        this(clientID, clientSecret, null, null);
    }

    public void authenticate(String authCode) {
        URL url = null;
        try {
            url = new URL(this.tokenURL);
        }
        catch (MalformedURLException e) {
            assert (false) : "An invalid token URL indicates a bug in the SDK.";
            throw new RuntimeException("An invalid token URL indicates a bug in the SDK.", e);
        }
        String urlParameters = String.format("grant_type=authorization_code&code=%s&client_id=%s&client_secret=%s", authCode, this.clientID, this.clientSecret);
        BoxAPIRequest request = new BoxAPIRequest(url, "POST");
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        request.setBody(urlParameters);
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        String json = response.getJSON();
        JsonObject jsonObject = JsonObject.readFrom((String)json);
        this.accessToken = jsonObject.get("access_token").asString();
        this.refreshToken = jsonObject.get("refresh_token").asString();
        this.lastRefresh = System.currentTimeMillis();
        this.expires = jsonObject.get("expires_in").asLong() * 1000L;
    }

    public void setExpires(long milliseconds) {
        this.expires = milliseconds;
    }

    public long getExpires() {
        return this.expires;
    }

    public String getTokenURL() {
        return this.tokenURL;
    }

    public void setTokenURL(String tokenURL) {
        this.tokenURL = tokenURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseUploadURL() {
        return this.baseUploadURL;
    }

    public void setBaseUploadURL(String baseUploadURL) {
        this.baseUploadURL = baseUploadURL;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken() {
        if (this.autoRefresh && this.canRefresh() && this.needsRefresh()) {
            this.refreshLock.writeLock().lock();
            try {
                if (this.needsRefresh()) {
                    this.refresh();
                }
            }
            finally {
                this.refreshLock.writeLock().unlock();
            }
        }
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public boolean getAutoRefresh() {
        return this.autoRefresh;
    }

    public int getMaxRequestAttempts() {
        return this.maxRequestAttempts;
    }

    public void setMaxRequestAttempts(int attempts) {
        this.maxRequestAttempts = attempts;
    }

    public boolean canRefresh() {
        return this.refreshToken != null;
    }

    public boolean needsRefresh() {
        long now;
        long tokenDuration;
        this.refreshLock.readLock().lock();
        boolean needsRefresh = this.expires == 0L ? false : (tokenDuration = (now = System.currentTimeMillis()) - this.lastRefresh) >= this.expires - 60000L;
        this.refreshLock.readLock().unlock();
        return needsRefresh;
    }

    public void refresh() {
        String json;
        this.refreshLock.writeLock().lock();
        if (!this.canRefresh()) {
            this.refreshLock.writeLock().unlock();
            throw new IllegalStateException("The BoxAPIConnection cannot be refreshed because it doesn't have a refresh token.");
        }
        URL url = null;
        try {
            url = new URL(this.tokenURL);
        }
        catch (MalformedURLException e) {
            this.refreshLock.writeLock().unlock();
            assert (false) : "An invalid refresh URL indicates a bug in the SDK.";
            throw new RuntimeException("An invalid refresh URL indicates a bug in the SDK.", e);
        }
        String urlParameters = String.format("grant_type=refresh_token&refresh_token=%s&client_id=%s&client_secret=%s", this.refreshToken, this.clientID, this.clientSecret);
        BoxAPIRequest request = new BoxAPIRequest(url, "POST");
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        request.setBody(urlParameters);
        try {
            BoxJSONResponse response = (BoxJSONResponse)request.send();
            json = response.getJSON();
        }
        catch (BoxAPIException e) {
            this.refreshLock.writeLock().unlock();
            throw e;
        }
        JsonObject jsonObject = JsonObject.readFrom((String)json);
        this.accessToken = jsonObject.get("access_token").asString();
        this.refreshToken = jsonObject.get("refresh_token").asString();
        this.lastRefresh = System.currentTimeMillis();
        this.expires = jsonObject.get("expires_in").asLong() * 1000L;
        this.notifyRefresh();
        this.refreshLock.writeLock().unlock();
    }

    private void notifyRefresh() {
        for (BoxAPIConnectionListener listener : this.listeners) {
            listener.onRefresh();
        }
    }

    public void addListener(BoxAPIConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BoxAPIConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public RequestInterceptor getRequestInterceptor() {
        return this.interceptor;
    }

    public void setRequestInterceptor(RequestInterceptor interceptor) {
        this.interceptor = interceptor;
    }
}

