/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxResource;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;

public class BoxEvent
extends BoxResource {
    private BoxResource.Info sourceInfo;
    private Type type;

    public BoxEvent(BoxAPIConnection api, String json) {
        this(api, JsonObject.readFrom((String)json));
    }

    BoxEvent(BoxAPIConnection api, JsonObject jsonObject) {
        super(api, jsonObject.get("event_id").asString());
        for (JsonObject.Member member : jsonObject) {
            if (member.getValue().isNull()) continue;
            this.parseJsonMember(member);
        }
    }

    public BoxResource.Info getSourceInfo() {
        return this.sourceInfo;
    }

    public Type getType() {
        return this.type;
    }

    void parseJsonMember(JsonObject.Member member) {
        JsonValue value = member.getValue();
        if (value.isNull()) {
            return;
        }
        switch (member.getName()) {
            case "source": {
                this.sourceInfo = BoxResource.parseInfo(this.getAPI(), value.asObject());
                break;
            }
            case "event_type": {
                String stringValue = value.asString();
                for (Type t : Type.values()) {
                    if (!t.name().equals(stringValue)) continue;
                    this.type = t;
                    break;
                }
                if (this.type != null) break;
                this.type = Type.UNKNOWN;
                break;
            }
        }
    }

    public static enum Type {
        UNKNOWN,
        ITEM_CREATE,
        ITEM_UPLOAD,
        COMMENT_CREATE,
        ITEM_DOWNLOAD,
        ITEM_PREVIEW,
        ITEM_MOVE,
        ITEM_COPY,
        TASK_ASSIGNMENT_CREATE,
        LOCK_CREATE,
        LOCK_DESTROY,
        ITEM_TRASH,
        ITEM_UNDELETE_VIA_TRASH,
        COLLAB_ADD_COLLABORATOR,
        COLLAB_REMOVE_COLLABORATOR,
        COLLAB_INVITE_COLLABORATOR,
        COLLAB_ROLE_CHANGE,
        ITEM_SYNC,
        ITEM_UNSYNC,
        ITEM_RENAME,
        ITEM_SHARED_CREATE,
        ITEM_SHARED_UNSHARE,
        ITEM_SHARED,
        TAG_ITEM_CREATE,
        ADD_LOGIN_ACTIVITY_DEVICE,
        REMOVE_LOGIN_ACTIVITY_DEVICE,
        CHANGE_ADMIN_ROLE;

    }
}

