/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxComment;
import com.box.sdk.BoxFileVersion;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxMultipartRequest;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.Metadata;
import com.box.sdk.ProgressListener;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;

public class BoxFile
extends BoxItem {
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "sequence_id", "etag", "sha1", "name", "description", "size", "path_collection", "created_at", "modified_at", "trashed_at", "purged_at", "content_created_at", "content_modified_at", "created_by", "modified_by", "owned_by", "shared_link", "parent", "item_status", "version_number", "comment_count", "permissions", "tags", "lock", "extension", "is_package"};
    private static final URLTemplate FILE_URL_TEMPLATE = new URLTemplate("files/%s");
    private static final URLTemplate CONTENT_URL_TEMPLATE = new URLTemplate("files/%s/content");
    private static final URLTemplate VERSIONS_URL_TEMPLATE = new URLTemplate("files/%s/versions");
    private static final URLTemplate COPY_URL_TEMPLATE = new URLTemplate("files/%s/copy");
    private static final URLTemplate ADD_COMMENT_URL_TEMPLATE = new URLTemplate("comments");
    private static final URLTemplate GET_COMMENTS_URL_TEMPLATE = new URLTemplate("files/%s/comments");
    private static final URLTemplate METADATA_URL_TEMPLATE = new URLTemplate("files/%s/metadata/%s");
    private static final String DEFAULT_METADATA_TYPE = "properties";
    private static final int BUFFER_SIZE = 8192;

    public BoxFile(BoxAPIConnection api, String id) {
        super(api, id);
    }

    @Override
    public BoxSharedLink createSharedLink(BoxSharedLink.Access access, Date unshareDate, BoxSharedLink.Permissions permissions) {
        BoxSharedLink sharedLink = new BoxSharedLink(access, unshareDate, permissions);
        Info info = new Info();
        info.setSharedLink(sharedLink);
        this.updateInfo(info);
        return info.getSharedLink();
    }

    public BoxComment.Info addComment(String message) {
        BoxComment addedComment;
        JsonObject itemJSON = new JsonObject();
        itemJSON.add("type", "file");
        itemJSON.add("id", this.getID());
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("item", (JsonValue)itemJSON);
        if (BoxComment.messageContainsMention(message)) {
            requestJSON.add("tagged_message", message);
        } else {
            requestJSON.add("message", message);
        }
        URL url = ADD_COMMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxComment boxComment = addedComment = new BoxComment(this.getAPI(), responseJSON.get("id").asString());
        boxComment.getClass();
        return boxComment.new BoxComment.Info(responseJSON);
    }

    public void download(OutputStream output) {
        this.download(output, null);
    }

    public void download(OutputStream output, ProgressListener listener) {
        URL url = CONTENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxAPIResponse response = request.send();
        InputStream input = response.getBody(listener);
        byte[] buffer = new byte[8192];
        try {
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
        response.disconnect();
    }

    public void downloadRange(OutputStream output, long offset) {
        this.downloadRange(output, offset, -1L);
    }

    public void downloadRange(OutputStream output, long rangeStart, long rangeEnd) {
        this.downloadRange(output, rangeStart, rangeEnd, null);
    }

    public void downloadRange(OutputStream output, long rangeStart, long rangeEnd, ProgressListener listener) {
        URL url = CONTENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        if (rangeEnd > 0L) {
            request.addHeader("Range", String.format("bytes=%s-%s", Long.toString(rangeStart), Long.toString(rangeEnd)));
        } else {
            request.addHeader("Range", String.format("bytes=%s-", Long.toString(rangeStart)));
        }
        BoxAPIResponse response = request.send();
        InputStream input = response.getBody(listener);
        byte[] buffer = new byte[8192];
        try {
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
        response.disconnect();
    }

    @Override
    public Info copy(BoxFolder destination) {
        return this.copy(destination, null);
    }

    @Override
    public Info copy(BoxFolder destination, String newName) {
        BoxFile copiedFile;
        URL url = COPY_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        JsonObject parent = new JsonObject();
        parent.add("id", destination.getID());
        JsonObject copyInfo = new JsonObject();
        copyInfo.add("parent", (JsonValue)parent);
        if (newName != null) {
            copyInfo.add("name", newName);
        }
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(copyInfo.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxFile boxFile = copiedFile = new BoxFile(this.getAPI(), responseJSON.get("id").asString());
        boxFile.getClass();
        return boxFile.new Info(responseJSON);
    }

    public void delete() {
        URL url = FILE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    @Override
    public BoxItem.Info move(BoxFolder destination) {
        return this.move(destination, null);
    }

    @Override
    public BoxItem.Info move(BoxFolder destination, String newName) {
        BoxFile movedFile;
        URL url = FILE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject parent = new JsonObject();
        parent.add("id", destination.getID());
        JsonObject updateInfo = new JsonObject();
        updateInfo.add("parent", (JsonValue)parent);
        if (newName != null) {
            updateInfo.add("name", newName);
        }
        request.setBody(updateInfo.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxFile boxFile = movedFile = new BoxFile(this.getAPI(), responseJSON.get("id").asString());
        boxFile.getClass();
        return boxFile.new Info(responseJSON);
    }

    public void rename(String newName) {
        URL url = FILE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject updateInfo = new JsonObject();
        updateInfo.add("name", newName);
        request.setBody(updateInfo.toString());
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    @Override
    public Info getInfo() {
        URL url = FILE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(response.getJSON());
    }

    @Override
    public Info getInfo(String ... fields) {
        String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
        URL url = FILE_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(response.getJSON());
    }

    public void updateInfo(Info info) {
        URL url = FILE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        info.update(jsonObject);
    }

    public Collection<BoxFileVersion> getVersions() {
        URL url = VERSIONS_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        JsonArray entries = jsonObject.get("entries").asArray();
        ArrayList<BoxFileVersion> versions = new ArrayList<BoxFileVersion>();
        for (JsonValue entry : entries) {
            versions.add(new BoxFileVersion(this.getAPI(), entry.asObject(), this.getID()));
        }
        return versions;
    }

    public void uploadVersion(InputStream fileContent) {
        this.uploadVersion(fileContent, null);
    }

    public void uploadVersion(InputStream fileContent, Date modified) {
        this.uploadVersion(fileContent, modified, 0L, null);
    }

    public void uploadVersion(InputStream fileContent, Date modified, long fileSize, ProgressListener listener) {
        URL uploadURL = CONTENT_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), this.getID());
        BoxMultipartRequest request = new BoxMultipartRequest(this.getAPI(), uploadURL);
        if (fileSize > 0L) {
            request.setFile(fileContent, "", fileSize);
        } else {
            request.setFile(fileContent, "");
        }
        if (modified != null) {
            request.putField("content_modified_at", modified);
        }
        BoxAPIResponse response = listener == null ? request.send() : request.send(listener);
        response.disconnect();
    }

    public List<BoxComment.Info> getComments() {
        URL url = GET_COMMENTS_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        int totalCount = responseJSON.get("total_count").asInt();
        ArrayList<BoxComment.Info> comments = new ArrayList<BoxComment.Info>(totalCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue value : entries) {
            BoxComment comment;
            JsonObject commentJSON = value.asObject();
            BoxComment boxComment = comment = new BoxComment(this.getAPI(), commentJSON.get("id").asString());
            boxComment.getClass();
            BoxComment.Info info = boxComment.new BoxComment.Info(commentJSON);
            comments.add(info);
        }
        return comments;
    }

    public Metadata createMetadata(Metadata metadata) {
        return this.createMetadata(DEFAULT_METADATA_TYPE, metadata);
    }

    public Metadata createMetadata(String typeName, Metadata metadata) {
        URL url = METADATA_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID(), typeName);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "POST");
        request.addHeader("Content-Type", "application/json");
        request.setBody(metadata.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Metadata(JsonObject.readFrom((String)response.getJSON()));
    }

    public Metadata getMetadata() {
        return this.getMetadata(DEFAULT_METADATA_TYPE);
    }

    public Metadata getMetadata(String typeName) {
        URL url = METADATA_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID(), typeName);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Metadata(JsonObject.readFrom((String)response.getJSON()));
    }

    public Metadata updateMetadata(Metadata metadata) {
        URL url = METADATA_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID(), metadata.getTypeName());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "PUT");
        request.addHeader("Content-Type", "application/json-patch+json");
        request.setBody(metadata.getPatch());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Metadata(JsonObject.readFrom((String)response.getJSON()));
    }

    public void deleteMetadata() {
        this.deleteMetadata(DEFAULT_METADATA_TYPE);
    }

    public void deleteMetadata(String typeName) {
        URL url = METADATA_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID(), typeName);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        request.send();
    }

    public static enum Permission {
        CAN_DOWNLOAD("can_download"),
        CAN_UPLOAD("can_upload"),
        CAN_RENAME("can_rename"),
        CAN_DELETE("can_delete"),
        CAN_SHARE("can_share"),
        CAN_SET_SHARE_ACCESS("can_set_share_access"),
        CAN_PREVIEW("can_preview"),
        CAN_COMMENT("can_comment");

        private final String jsonValue;

        private Permission(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Permission fromJSONValue(String jsonValue) {
            return Permission.valueOf(jsonValue.toUpperCase());
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }

    public class Info
    extends BoxItem.Info {
        private String sha1;
        private String versionNumber;
        private long commentCount;
        private EnumSet<Permission> permissions;
        private String extension;
        private boolean isPackage;

        public Info() {
            super(BoxFile.this);
        }

        public Info(String json) {
            super((BoxItem)BoxFile.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxItem)BoxFile.this, jsonObject);
        }

        @Override
        public BoxFile getResource() {
            return BoxFile.this;
        }

        public String getSha1() {
            return this.sha1;
        }

        public String getVersionNumber() {
            return this.versionNumber;
        }

        public long getCommentCount() {
            return this.commentCount;
        }

        public EnumSet<Permission> getPermissions() {
            return this.permissions;
        }

        public String getExtension() {
            return this.extension;
        }

        public boolean getIsPackage() {
            return this.isPackage;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            switch (memberName) {
                case "sha1": {
                    this.sha1 = value.asString();
                    break;
                }
                case "version_number": {
                    this.versionNumber = value.asString();
                    break;
                }
                case "comment_count": {
                    this.commentCount = value.asLong();
                    break;
                }
                case "permissions": {
                    this.permissions = this.parsePermissions(value.asObject());
                    break;
                }
                case "extension": {
                    this.extension = value.asString();
                    break;
                }
                case "is_package": {
                    this.isPackage = value.asBoolean();
                    break;
                }
            }
        }

        private EnumSet<Permission> parsePermissions(JsonObject jsonObject) {
            EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
            for (JsonObject.Member member : jsonObject) {
                String memberName;
                JsonValue value = member.getValue();
                if (value.isNull() || !value.asBoolean()) continue;
                switch (memberName = member.getName()) {
                    case "can_download": {
                        permissions.add(Permission.CAN_DOWNLOAD);
                        break;
                    }
                    case "can_upload": {
                        permissions.add(Permission.CAN_UPLOAD);
                        break;
                    }
                    case "can_rename": {
                        permissions.add(Permission.CAN_RENAME);
                        break;
                    }
                    case "can_delete": {
                        permissions.add(Permission.CAN_DELETE);
                        break;
                    }
                    case "can_share": {
                        permissions.add(Permission.CAN_SHARE);
                        break;
                    }
                    case "can_set_share_access": {
                        permissions.add(Permission.CAN_SET_SHARE_ACCESS);
                        break;
                    }
                    case "can_preview": {
                        permissions.add(Permission.CAN_PREVIEW);
                        break;
                    }
                    case "can_comment": {
                        permissions.add(Permission.CAN_COMMENT);
                        break;
                    }
                }
            }
            return permissions;
        }
    }
}

