/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.BoxUser;
import com.box.sdk.SharedLinkAPIConnection;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class BoxItem
extends BoxResource {
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "sequence_id", "etag", "sha1", "name", "description", "size", "path_collection", "created_at", "modified_at", "trashed_at", "purged_at", "content_created_at", "content_modified_at", "created_by", "modified_by", "owned_by", "shared_link", "parent", "item_status", "version_number", "comment_count", "permissions", "tags", "lock", "extension", "is_package", "folder_upload_email", "item_collection", "sync_state", "has_collaborations", "can_non_owners_invite"};
    private static final URLTemplate SHARED_ITEM_URL_TEMPLATE = new URLTemplate("shared_items");

    public BoxItem(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info getSharedItem(BoxAPIConnection api, String sharedLink) {
        return BoxItem.getSharedItem(api, sharedLink, null);
    }

    public static Info getSharedItem(BoxAPIConnection api, String sharedLink, String password) {
        SharedLinkAPIConnection newAPI = new SharedLinkAPIConnection(api, sharedLink, password);
        URL url = SHARED_ITEM_URL_TEMPLATE.build(((BoxAPIConnection)newAPI).getBaseURL(), new Object[0]);
        BoxAPIRequest request = new BoxAPIRequest(newAPI, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject json = JsonObject.readFrom((String)response.getJSON());
        return (Info)BoxResource.parseInfo(newAPI, json);
    }

    public abstract Info copy(BoxFolder var1);

    public abstract Info copy(BoxFolder var1, String var2);

    public abstract Info move(BoxFolder var1);

    public abstract Info move(BoxFolder var1, String var2);

    public abstract BoxSharedLink createSharedLink(BoxSharedLink.Access var1, Date var2, BoxSharedLink.Permissions var3);

    public abstract Info getInfo();

    public abstract Info getInfo(String ... var1);

    public abstract class Info
    extends BoxResource.Info {
        private String sequenceID;
        private String etag;
        private String name;
        private Date createdAt;
        private Date modifiedAt;
        private String description;
        private long size;
        private List<BoxFolder> pathCollection;
        private BoxUser.Info createdBy;
        private BoxUser.Info modifiedBy;
        private Date trashedAt;
        private Date purgedAt;
        private Date contentCreatedAt;
        private Date contentModifiedAt;
        private BoxUser.Info ownedBy;
        private BoxSharedLink sharedLink;
        private List<String> tags;
        private BoxFolder.Info parent;
        private String itemStatus;

        public Info() {
            super(BoxItem.this);
        }

        public Info(String json) {
            super((BoxResource)BoxItem.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxItem.this, jsonObject);
        }

        public String getEtag() {
            return this.etag;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.addPendingChange("name", name);
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
            this.addPendingChange("description", description);
        }

        public long getSize() {
            return this.size;
        }

        public List<BoxFolder> getPathCollection() {
            return this.pathCollection;
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public BoxUser.Info getModifiedBy() {
            return this.modifiedBy;
        }

        public Date getTrashedAt() {
            return this.trashedAt;
        }

        public Date getPurgedAt() {
            return this.purgedAt;
        }

        public Date getContentCreatedAt() {
            return this.contentCreatedAt;
        }

        public Date getContentModifiedAt() {
            return this.contentModifiedAt;
        }

        public BoxUser.Info getOwnedBy() {
            return this.ownedBy;
        }

        public BoxSharedLink getSharedLink() {
            return this.sharedLink;
        }

        public void setSharedLink(BoxSharedLink sharedLink) {
            if (this.sharedLink == sharedLink) {
                return;
            }
            this.removeChildObject("shared_link");
            this.sharedLink = sharedLink;
            this.addChildObject("shared_link", sharedLink);
        }

        public String getSequenceID() {
            return this.sequenceID;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public BoxFolder.Info getParent() {
            return this.parent;
        }

        public String getItemStatus() {
            return this.itemStatus;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            block46: {
                super.parseJSONMember(member);
                try {
                    JsonValue value = member.getValue();
                    switch (member.getName()) {
                        case "sequence_id": {
                            this.sequenceID = value.asString();
                            break;
                        }
                        case "etag": {
                            this.etag = value.asString();
                            break;
                        }
                        case "name": {
                            this.name = value.asString();
                            break;
                        }
                        case "created_at": {
                            this.createdAt = BoxDateFormat.parse(value.asString());
                            break;
                        }
                        case "modified_at": {
                            this.modifiedAt = BoxDateFormat.parse(value.asString());
                            break;
                        }
                        case "description": {
                            this.description = value.asString();
                            break;
                        }
                        case "size": {
                            this.size = Double.valueOf(value.toString()).longValue();
                            break;
                        }
                        case "trashed_at": {
                            this.trashedAt = BoxDateFormat.parse(value.asString());
                            break;
                        }
                        case "purged_at": {
                            this.purgedAt = BoxDateFormat.parse(value.asString());
                            break;
                        }
                        case "content_created_at": {
                            this.contentCreatedAt = BoxDateFormat.parse(value.asString());
                            break;
                        }
                        case "content_modified_at": {
                            this.contentModifiedAt = BoxDateFormat.parse(value.asString());
                            break;
                        }
                        case "path_collection": {
                            this.pathCollection = this.parsePathCollection(value.asObject());
                            break;
                        }
                        case "created_by": {
                            this.createdBy = this.parseUserInfo(value.asObject());
                            break;
                        }
                        case "modified_by": {
                            this.modifiedBy = this.parseUserInfo(value.asObject());
                            break;
                        }
                        case "owned_by": {
                            this.ownedBy = this.parseUserInfo(value.asObject());
                            break;
                        }
                        case "shared_link": {
                            if (this.sharedLink == null) {
                                this.setSharedLink(new BoxSharedLink(value.asObject()));
                                break;
                            }
                            this.sharedLink.update(value.asObject());
                            break;
                        }
                        case "tags": {
                            this.tags = this.parseTags(value.asArray());
                            break;
                        }
                        case "parent": {
                            JsonObject jsonObject = value.asObject();
                            if (this.parent == null) {
                                BoxFolder parentFolder;
                                String id = jsonObject.get("id").asString();
                                BoxFolder boxFolder = parentFolder = new BoxFolder(BoxItem.this.getAPI(), id);
                                boxFolder.getClass();
                                this.parent = boxFolder.new BoxFolder.Info(jsonObject);
                                break;
                            }
                            this.parent.update(jsonObject);
                            break;
                        }
                        case "item_status": {
                            this.itemStatus = value.asString();
                            break;
                        }
                    }
                }
                catch (ParseException e) {
                    if ($assertionsDisabled) break block46;
                    throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
                }
            }
        }

        private List<BoxFolder> parsePathCollection(JsonObject jsonObject) {
            int count = jsonObject.get("total_count").asInt();
            ArrayList<BoxFolder> pathCollection = new ArrayList<BoxFolder>(count);
            JsonArray entries = jsonObject.get("entries").asArray();
            for (JsonValue value : entries) {
                JsonObject entry = value.asObject();
                String id = entry.get("id").asString();
                pathCollection.add(new BoxFolder(BoxItem.this.getAPI(), id));
            }
            return pathCollection;
        }

        private BoxUser.Info parseUserInfo(JsonObject jsonObject) {
            BoxUser user;
            String userID = jsonObject.get("id").asString();
            BoxUser boxUser = user = new BoxUser(BoxItem.this.getAPI(), userID);
            boxUser.getClass();
            return new BoxUser.Info(boxUser, jsonObject);
        }

        private List<String> parseTags(JsonArray jsonArray) {
            ArrayList<String> tags = new ArrayList<String>(jsonArray.size());
            for (JsonValue value : jsonArray) {
                tags.add(value.asString());
            }
            return tags;
        }
    }
}

