/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxCollaboration;
import com.box.sdk.BoxComment;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxUser;
import com.eclipsesource.json.JsonObject;

public abstract class BoxResource {
    private final BoxAPIConnection api;
    private final String id;

    public BoxResource(BoxAPIConnection api, String id) {
        this.api = api;
        this.id = id;
    }

    static Info parseInfo(BoxAPIConnection api, JsonObject jsonObject) {
        String type = jsonObject.get("type").asString();
        String id = jsonObject.get("id").asString();
        switch (type) {
            case "folder": {
                BoxFolder folder;
                BoxFolder boxFolder = folder = new BoxFolder(api, id);
                boxFolder.getClass();
                return boxFolder.new BoxFolder.Info(jsonObject);
            }
            case "file": {
                BoxFile file;
                BoxFile boxFile = file = new BoxFile(api, id);
                boxFile.getClass();
                return boxFile.new BoxFile.Info(jsonObject);
            }
            case "comment": {
                BoxComment comment;
                BoxComment boxComment = comment = new BoxComment(api, id);
                boxComment.getClass();
                return boxComment.new BoxComment.Info(jsonObject);
            }
            case "collaboration": {
                BoxCollaboration collaboration;
                BoxCollaboration boxCollaboration = collaboration = new BoxCollaboration(api, id);
                boxCollaboration.getClass();
                return boxCollaboration.new BoxCollaboration.Info(jsonObject);
            }
            case "user": {
                BoxUser user;
                BoxUser boxUser = user = new BoxUser(api, id);
                boxUser.getClass();
                return new BoxUser.Info(boxUser, jsonObject);
            }
            case "group": {
                BoxGroup group;
                BoxGroup boxGroup = group = new BoxGroup(api, id);
                boxGroup.getClass();
                return boxGroup.new BoxGroup.Info(jsonObject);
            }
        }
        return null;
    }

    public BoxAPIConnection getAPI() {
        return this.api;
    }

    public String getID() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass().equals(other.getClass())) {
            BoxResource otherResource = (BoxResource)other;
            return this.getID().equals(otherResource.getID());
        }
        return false;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public abstract class Info
    extends BoxJSONObject {
        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public String getID() {
            return BoxResource.this.getID();
        }

        public abstract BoxResource getResource();
    }
}

