/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxUser;
import com.box.sdk.ProgressListener;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;

public class BoxFileVersion
extends BoxResource {
    private static final URLTemplate CONTENT_URL_TEMPLATE = new URLTemplate("files/%s/content?version=%s");
    private static final URLTemplate VERSION_URL_TEMPLATE = new URLTemplate("files/%s/versions/%s");
    private static final int BUFFER_SIZE = 8192;
    private final String fileID;
    private String sha1;
    private String name;
    private long size;
    private Date createdAt;
    private Date modifiedAt;
    private BoxUser.Info modifiedBy;

    public BoxFileVersion(BoxAPIConnection api, String json, String fileID) {
        this(api, JsonObject.readFrom((String)json), fileID);
    }

    BoxFileVersion(BoxAPIConnection api, JsonObject jsonObject, String fileID) {
        super(api, jsonObject.get("id").asString());
        this.fileID = fileID;
        for (JsonObject.Member member : jsonObject) {
            JsonValue value = member.getValue();
            if (value.isNull()) continue;
            try {
                BoxUser user;
                String memberName = member.getName();
                if (memberName.equals("sha1")) {
                    this.sha1 = value.asString();
                    continue;
                }
                if (memberName.equals("name")) {
                    this.name = value.asString();
                    continue;
                }
                if (memberName.equals("size")) {
                    this.size = Double.valueOf(value.toString()).longValue();
                    continue;
                }
                if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                    continue;
                }
                if (memberName.equals("modified_at")) {
                    this.modifiedAt = BoxDateFormat.parse(value.asString());
                    continue;
                }
                if (!memberName.equals("modified_by")) continue;
                JsonObject userJSON = value.asObject();
                String userID = userJSON.get("id").asString();
                BoxUser boxUser = user = new BoxUser(this.getAPI(), userID);
                boxUser.getClass();
                this.modifiedBy = new BoxUser.Info(boxUser, userJSON);
            }
            catch (ParseException e) {
                assert (false) : "A ParseException indicates a bug in the SDK.";
            }
        }
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public BoxUser.Info getModifiedBy() {
        return this.modifiedBy;
    }

    public void delete() {
        URL url = VERSION_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.fileID, this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public void download(OutputStream output) {
        this.download(output, null);
    }

    public void download(OutputStream output, ProgressListener listener) {
        URL url = CONTENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.fileID, this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxAPIResponse response = request.send();
        InputStream input = response.getBody(listener);
        long totalRead = 0L;
        byte[] buffer = new byte[8192];
        try {
            int n = input.read(buffer);
            totalRead += (long)n;
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
                totalRead += (long)n;
            }
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
        response.disconnect();
    }

    public void promote() {
        URL url = VERSION_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.fileID, "current");
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", "file_version");
        jsonObject.add("id", this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(jsonObject.toString());
        BoxAPIResponse response = request.send();
        response.disconnect();
    }
}

