/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;

public class BoxUser
extends BoxCollaborator {
    private static final URLTemplate GET_USER_URL = new URLTemplate("users/%s");
    private static final URLTemplate GET_ME_URL = new URLTemplate("users/me");

    public BoxUser(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static BoxUser getCurrentUser(BoxAPIConnection api) {
        URL url = GET_ME_URL.build(api.getBaseURL(), new Object[0]);
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        return new BoxUser(api, jsonObject.get("id").asString());
    }

    public Info getInfo() {
        URL url = GET_USER_URL.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        return new Info(jsonObject);
    }

    public class Info
    extends BoxCollaborator.Info {
        private String login;
        private Role role;
        private String language;
        private String timezone;
        private long spaceAmount;
        private long spaceUsed;
        private long maxUploadSize;
        private Status status;
        private String jobTitle;
        private String phone;
        private String address;
        private String avatarURL;

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxUser getResource() {
            return BoxUser.this;
        }

        public String getLogin() {
            return this.login;
        }

        public Role getRole() {
            return this.role;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getTimezone() {
            return this.timezone;
        }

        public long getSpaceAmount() {
            return this.spaceAmount;
        }

        public long getSpaceUsed() {
            return this.spaceUsed;
        }

        public long getMaxUploadSize() {
            return this.maxUploadSize;
        }

        public Status getStatus() {
            return this.status;
        }

        public String getJobTitle() {
            return this.jobTitle;
        }

        public String getPhone() {
            return this.phone;
        }

        public String getAddress() {
            return this.address;
        }

        public String getAvatarURL() {
            return this.avatarURL;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if (memberName.equals("login")) {
                this.login = value.asString();
            } else if (memberName.equals("role")) {
                this.role = this.parseRole(value);
            } else if (memberName.equals("language")) {
                this.language = value.asString();
            } else if (memberName.equals("timezone")) {
                this.timezone = value.asString();
            } else if (memberName.equals("space_amount")) {
                this.spaceAmount = Double.valueOf(value.toString()).longValue();
            } else if (memberName.equals("space_used")) {
                this.spaceUsed = Double.valueOf(value.toString()).longValue();
            } else if (memberName.equals("max_upload_size")) {
                this.maxUploadSize = Double.valueOf(value.toString()).longValue();
            } else if (memberName.equals("status")) {
                this.status = this.parseStatus(value);
            } else if (memberName.equals("job_title")) {
                this.jobTitle = value.asString();
            } else if (memberName.equals("phone")) {
                this.phone = value.asString();
            } else if (memberName.equals("address")) {
                this.address = value.asString();
            } else if (memberName.equals("avatar_url")) {
                this.avatarURL = value.asString();
            }
        }

        private Role parseRole(JsonValue value) {
            String roleString = value.asString().toUpperCase();
            return Role.valueOf(roleString);
        }

        private Status parseStatus(JsonValue value) {
            String statusString = value.asString().toUpperCase();
            return Status.valueOf(statusString);
        }
    }

    public static enum Status {
        ACTIVE,
        INACTIVE,
        CANNOT_DELETE_EDIT,
        CANNOT_DELETE_EDIT_UPLOAD;

    }

    public static enum Role {
        ADMIN,
        COADMIN,
        USER;

    }
}

