/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.appitemassociations;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.appitemassociations.GetFileAppItemAssociationsHeaders;
import com.box.sdkgen.managers.appitemassociations.GetFileAppItemAssociationsQueryParams;
import com.box.sdkgen.managers.appitemassociations.GetFolderAppItemAssociationsHeaders;
import com.box.sdkgen.managers.appitemassociations.GetFolderAppItemAssociationsQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.appitemassociations.AppItemAssociations;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class AppItemAssociationsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public AppItemAssociationsManager() {
        this.networkSession = new NetworkSession();
    }

    protected AppItemAssociationsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public AppItemAssociations getFileAppItemAssociations(String fileId) {
        return this.getFileAppItemAssociations(fileId, new GetFileAppItemAssociationsQueryParams(), new GetFileAppItemAssociationsHeaders());
    }

    public AppItemAssociations getFileAppItemAssociations(String fileId, GetFileAppItemAssociationsQueryParams queryParams) {
        return this.getFileAppItemAssociations(fileId, queryParams, new GetFileAppItemAssociationsHeaders());
    }

    public AppItemAssociations getFileAppItemAssociations(String fileId, GetFileAppItemAssociationsHeaders headers) {
        return this.getFileAppItemAssociations(fileId, new GetFileAppItemAssociationsQueryParams(), headers);
    }

    public AppItemAssociations getFileAppItemAssociations(String fileId, GetFileAppItemAssociationsQueryParams queryParams, GetFileAppItemAssociationsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("application_type", UtilsManager.convertToString(queryParams.getApplicationType()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/app_item_associations"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AppItemAssociations.class);
    }

    public AppItemAssociations getFolderAppItemAssociations(String folderId) {
        return this.getFolderAppItemAssociations(folderId, new GetFolderAppItemAssociationsQueryParams(), new GetFolderAppItemAssociationsHeaders());
    }

    public AppItemAssociations getFolderAppItemAssociations(String folderId, GetFolderAppItemAssociationsQueryParams queryParams) {
        return this.getFolderAppItemAssociations(folderId, queryParams, new GetFolderAppItemAssociationsHeaders());
    }

    public AppItemAssociations getFolderAppItemAssociations(String folderId, GetFolderAppItemAssociationsHeaders headers) {
        return this.getFolderAppItemAssociations(folderId, new GetFolderAppItemAssociationsQueryParams(), headers);
    }

    public AppItemAssociations getFolderAppItemAssociations(String folderId, GetFolderAppItemAssociationsQueryParams queryParams, GetFolderAppItemAssociationsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("application_type", UtilsManager.convertToString(queryParams.getApplicationType()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/app_item_associations"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AppItemAssociations.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public AppItemAssociationsManager build() {
            return new AppItemAssociationsManager(this);
        }
    }
}

