/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.avatars;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.avatars.CreateUserAvatarHeaders;
import com.box.sdkgen.managers.avatars.CreateUserAvatarRequestBody;
import com.box.sdkgen.managers.avatars.DeleteUserAvatarHeaders;
import com.box.sdkgen.managers.avatars.GetUserAvatarHeaders;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.MultipartItem;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.useravatar.UserAvatar;
import com.box.sdkgen.serialization.json.JsonManager;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;

public class AvatarsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public AvatarsManager() {
        this.networkSession = new NetworkSession();
    }

    protected AvatarsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public InputStream getUserAvatar(String userId) {
        return this.getUserAvatar(userId, new GetUserAvatarHeaders());
    }

    public InputStream getUserAvatar(String userId, GetUserAvatarHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/", UtilsManager.convertToString(userId), "/avatar"), "GET").headers(headersMap).responseFormat(ResponseFormat.BINARY).auth(this.auth).networkSession(this.networkSession).build());
        return response.getContent();
    }

    public UserAvatar createUserAvatar(String userId, CreateUserAvatarRequestBody requestBody) {
        return this.createUserAvatar(userId, requestBody, new CreateUserAvatarHeaders());
    }

    public UserAvatar createUserAvatar(String userId, CreateUserAvatarRequestBody requestBody, CreateUserAvatarHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/", UtilsManager.convertToString(userId), "/avatar"), "POST").headers(headersMap).multipartData(Arrays.asList(new MultipartItem.Builder("pic").fileStream(requestBody.getPic()).fileName(requestBody.getPicFileName()).contentType(requestBody.getPicContentType()).build())).contentType("multipart/form-data").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), UserAvatar.class);
    }

    public void deleteUserAvatar(String userId) {
        this.deleteUserAvatar(userId, new DeleteUserAvatarHeaders());
    }

    public void deleteUserAvatar(String userId, DeleteUserAvatarHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/users/", UtilsManager.convertToString(userId), "/avatar"), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public AvatarsManager build() {
            return new AvatarsManager(this);
        }
    }
}

