/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.retentionpolicyassignments;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.retentionpolicyassignments.CreateRetentionPolicyAssignmentHeaders;
import com.box.sdkgen.managers.retentionpolicyassignments.CreateRetentionPolicyAssignmentRequestBody;
import com.box.sdkgen.managers.retentionpolicyassignments.DeleteRetentionPolicyAssignmentByIdHeaders;
import com.box.sdkgen.managers.retentionpolicyassignments.GetFilesUnderRetentionPolicyAssignmentHeaders;
import com.box.sdkgen.managers.retentionpolicyassignments.GetFilesUnderRetentionPolicyAssignmentQueryParams;
import com.box.sdkgen.managers.retentionpolicyassignments.GetRetentionPolicyAssignmentByIdHeaders;
import com.box.sdkgen.managers.retentionpolicyassignments.GetRetentionPolicyAssignmentByIdQueryParams;
import com.box.sdkgen.managers.retentionpolicyassignments.GetRetentionPolicyAssignmentsHeaders;
import com.box.sdkgen.managers.retentionpolicyassignments.GetRetentionPolicyAssignmentsQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.filesunderretention.FilesUnderRetention;
import com.box.sdkgen.schemas.retentionpolicyassignment.RetentionPolicyAssignment;
import com.box.sdkgen.schemas.retentionpolicyassignments.RetentionPolicyAssignments;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class RetentionPolicyAssignmentsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public RetentionPolicyAssignmentsManager() {
        this.networkSession = new NetworkSession();
    }

    protected RetentionPolicyAssignmentsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public RetentionPolicyAssignments getRetentionPolicyAssignments(String retentionPolicyId) {
        return this.getRetentionPolicyAssignments(retentionPolicyId, new GetRetentionPolicyAssignmentsQueryParams(), new GetRetentionPolicyAssignmentsHeaders());
    }

    public RetentionPolicyAssignments getRetentionPolicyAssignments(String retentionPolicyId, GetRetentionPolicyAssignmentsQueryParams queryParams) {
        return this.getRetentionPolicyAssignments(retentionPolicyId, queryParams, new GetRetentionPolicyAssignmentsHeaders());
    }

    public RetentionPolicyAssignments getRetentionPolicyAssignments(String retentionPolicyId, GetRetentionPolicyAssignmentsHeaders headers) {
        return this.getRetentionPolicyAssignments(retentionPolicyId, new GetRetentionPolicyAssignmentsQueryParams(), headers);
    }

    public RetentionPolicyAssignments getRetentionPolicyAssignments(String retentionPolicyId, GetRetentionPolicyAssignmentsQueryParams queryParams, GetRetentionPolicyAssignmentsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("type", UtilsManager.convertToString(queryParams.getType())), UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/retention_policies/", UtilsManager.convertToString(retentionPolicyId), "/assignments"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), RetentionPolicyAssignments.class);
    }

    public RetentionPolicyAssignment createRetentionPolicyAssignment(CreateRetentionPolicyAssignmentRequestBody requestBody) {
        return this.createRetentionPolicyAssignment(requestBody, new CreateRetentionPolicyAssignmentHeaders());
    }

    public RetentionPolicyAssignment createRetentionPolicyAssignment(CreateRetentionPolicyAssignmentRequestBody requestBody, CreateRetentionPolicyAssignmentHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/retention_policy_assignments"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), RetentionPolicyAssignment.class);
    }

    public RetentionPolicyAssignment getRetentionPolicyAssignmentById(String retentionPolicyAssignmentId) {
        return this.getRetentionPolicyAssignmentById(retentionPolicyAssignmentId, new GetRetentionPolicyAssignmentByIdQueryParams(), new GetRetentionPolicyAssignmentByIdHeaders());
    }

    public RetentionPolicyAssignment getRetentionPolicyAssignmentById(String retentionPolicyAssignmentId, GetRetentionPolicyAssignmentByIdQueryParams queryParams) {
        return this.getRetentionPolicyAssignmentById(retentionPolicyAssignmentId, queryParams, new GetRetentionPolicyAssignmentByIdHeaders());
    }

    public RetentionPolicyAssignment getRetentionPolicyAssignmentById(String retentionPolicyAssignmentId, GetRetentionPolicyAssignmentByIdHeaders headers) {
        return this.getRetentionPolicyAssignmentById(retentionPolicyAssignmentId, new GetRetentionPolicyAssignmentByIdQueryParams(), headers);
    }

    public RetentionPolicyAssignment getRetentionPolicyAssignmentById(String retentionPolicyAssignmentId, GetRetentionPolicyAssignmentByIdQueryParams queryParams, GetRetentionPolicyAssignmentByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/retention_policy_assignments/", UtilsManager.convertToString(retentionPolicyAssignmentId)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), RetentionPolicyAssignment.class);
    }

    public void deleteRetentionPolicyAssignmentById(String retentionPolicyAssignmentId) {
        this.deleteRetentionPolicyAssignmentById(retentionPolicyAssignmentId, new DeleteRetentionPolicyAssignmentByIdHeaders());
    }

    public void deleteRetentionPolicyAssignmentById(String retentionPolicyAssignmentId, DeleteRetentionPolicyAssignmentByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/retention_policy_assignments/", UtilsManager.convertToString(retentionPolicyAssignmentId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public FilesUnderRetention getFilesUnderRetentionPolicyAssignment(String retentionPolicyAssignmentId) {
        return this.getFilesUnderRetentionPolicyAssignment(retentionPolicyAssignmentId, new GetFilesUnderRetentionPolicyAssignmentQueryParams(), new GetFilesUnderRetentionPolicyAssignmentHeaders());
    }

    public FilesUnderRetention getFilesUnderRetentionPolicyAssignment(String retentionPolicyAssignmentId, GetFilesUnderRetentionPolicyAssignmentQueryParams queryParams) {
        return this.getFilesUnderRetentionPolicyAssignment(retentionPolicyAssignmentId, queryParams, new GetFilesUnderRetentionPolicyAssignmentHeaders());
    }

    public FilesUnderRetention getFilesUnderRetentionPolicyAssignment(String retentionPolicyAssignmentId, GetFilesUnderRetentionPolicyAssignmentHeaders headers) {
        return this.getFilesUnderRetentionPolicyAssignment(retentionPolicyAssignmentId, new GetFilesUnderRetentionPolicyAssignmentQueryParams(), headers);
    }

    public FilesUnderRetention getFilesUnderRetentionPolicyAssignment(String retentionPolicyAssignmentId, GetFilesUnderRetentionPolicyAssignmentQueryParams queryParams, GetFilesUnderRetentionPolicyAssignmentHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/retention_policy_assignments/", UtilsManager.convertToString(retentionPolicyAssignmentId), "/files_under_retention"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FilesUnderRetention.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public RetentionPolicyAssignmentsManager build() {
            return new RetentionPolicyAssignmentsManager(this);
        }
    }
}

