/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.task;

import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.filemini.FileMini;
import com.box.sdkgen.schemas.task.TaskActionField;
import com.box.sdkgen.schemas.task.TaskCompletionRuleField;
import com.box.sdkgen.schemas.task.TaskTypeField;
import com.box.sdkgen.schemas.taskassignments.TaskAssignments;
import com.box.sdkgen.schemas.usermini.UserMini;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class Task
extends SerializableObject {
    protected String id;
    @JsonDeserialize(using=TaskTypeField.TaskTypeFieldDeserializer.class)
    @JsonSerialize(using=TaskTypeField.TaskTypeFieldSerializer.class)
    protected EnumWrapper<TaskTypeField> type;
    protected FileMini item;
    @JsonProperty(value="due_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime dueAt;
    @JsonDeserialize(using=TaskActionField.TaskActionFieldDeserializer.class)
    @JsonSerialize(using=TaskActionField.TaskActionFieldSerializer.class)
    protected EnumWrapper<TaskActionField> action;
    protected String message;
    @JsonProperty(value="task_assignment_collection")
    protected TaskAssignments taskAssignmentCollection;
    @JsonProperty(value="is_completed")
    protected Boolean isCompleted;
    @JsonProperty(value="created_by")
    protected UserMini createdBy;
    @JsonProperty(value="created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime createdAt;
    @JsonDeserialize(using=TaskCompletionRuleField.TaskCompletionRuleFieldDeserializer.class)
    @JsonSerialize(using=TaskCompletionRuleField.TaskCompletionRuleFieldSerializer.class)
    @JsonProperty(value="completion_rule")
    protected EnumWrapper<TaskCompletionRuleField> completionRule;

    public Task() {
    }

    protected Task(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.item = builder.item;
        this.dueAt = builder.dueAt;
        this.action = builder.action;
        this.message = builder.message;
        this.taskAssignmentCollection = builder.taskAssignmentCollection;
        this.isCompleted = builder.isCompleted;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.completionRule = builder.completionRule;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getId() {
        return this.id;
    }

    public EnumWrapper<TaskTypeField> getType() {
        return this.type;
    }

    public FileMini getItem() {
        return this.item;
    }

    public OffsetDateTime getDueAt() {
        return this.dueAt;
    }

    public EnumWrapper<TaskActionField> getAction() {
        return this.action;
    }

    public String getMessage() {
        return this.message;
    }

    public TaskAssignments getTaskAssignmentCollection() {
        return this.taskAssignmentCollection;
    }

    public Boolean getIsCompleted() {
        return this.isCompleted;
    }

    public UserMini getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public EnumWrapper<TaskCompletionRuleField> getCompletionRule() {
        return this.completionRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task casted = (Task)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.type, casted.type) && Objects.equals(this.item, casted.item) && Objects.equals(this.dueAt, casted.dueAt) && Objects.equals(this.action, casted.action) && Objects.equals(this.message, casted.message) && Objects.equals(this.taskAssignmentCollection, casted.taskAssignmentCollection) && Objects.equals(this.isCompleted, casted.isCompleted) && Objects.equals(this.createdBy, casted.createdBy) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.completionRule, casted.completionRule);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.item, this.dueAt, this.action, this.message, this.taskAssignmentCollection, this.isCompleted, this.createdBy, this.createdAt, this.completionRule);
    }

    public String toString() {
        return "Task{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", item='" + this.item + '\'' + ", dueAt='" + this.dueAt + '\'' + ", action='" + this.action + '\'' + ", message='" + this.message + '\'' + ", taskAssignmentCollection='" + this.taskAssignmentCollection + '\'' + ", isCompleted='" + this.isCompleted + '\'' + ", createdBy='" + this.createdBy + '\'' + ", createdAt='" + this.createdAt + '\'' + ", completionRule='" + this.completionRule + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected String id;
        protected EnumWrapper<TaskTypeField> type;
        protected FileMini item;
        protected OffsetDateTime dueAt;
        protected EnumWrapper<TaskActionField> action;
        protected String message;
        protected TaskAssignments taskAssignmentCollection;
        protected Boolean isCompleted;
        protected UserMini createdBy;
        protected OffsetDateTime createdAt;
        protected EnumWrapper<TaskCompletionRuleField> completionRule;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder type(TaskTypeField type) {
            this.type = new EnumWrapper<TaskTypeField>(type);
            return this;
        }

        public Builder type(EnumWrapper<TaskTypeField> type) {
            this.type = type;
            return this;
        }

        public Builder item(FileMini item) {
            this.item = item;
            return this;
        }

        public Builder dueAt(OffsetDateTime dueAt) {
            this.dueAt = dueAt;
            return this;
        }

        public Builder action(TaskActionField action) {
            this.action = new EnumWrapper<TaskActionField>(action);
            return this;
        }

        public Builder action(EnumWrapper<TaskActionField> action) {
            this.action = action;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder taskAssignmentCollection(TaskAssignments taskAssignmentCollection) {
            this.taskAssignmentCollection = taskAssignmentCollection;
            return this;
        }

        public Builder isCompleted(Boolean isCompleted) {
            this.isCompleted = isCompleted;
            return this;
        }

        public Builder createdBy(UserMini createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder completionRule(TaskCompletionRuleField completionRule) {
            this.completionRule = new EnumWrapper<TaskCompletionRuleField>(completionRule);
            return this;
        }

        public Builder completionRule(EnumWrapper<TaskCompletionRuleField> completionRule) {
            this.completionRule = completionRule;
            return this;
        }

        public Task build() {
            return new Task(this);
        }
    }
}

