/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.internal.utils;

import com.box.sdkgen.box.errors.BoxSDKError;
import com.box.sdkgen.internal.SerializableObject;
import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.JwtKey;
import com.box.sdkgen.internal.utils.JwtSignOptions;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.box.sdkgen.serialization.json.JsonManager;
import com.box.sdkgen.serialization.json.Valuable;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;

public class UtilsManager {
    private static final int BUFFER_SIZE = 8192;
    private static final DateTimeFormatter OFFSET_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
    private static final DateTimeFormatter OFFSET_DATE_TIME_FORMAT_WITH_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private static final DateTimeFormatter OFFSET_DATE_TIME_FORMAT_WITH_MICROS = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSX");
    private static final DateTimeFormatter OFFSET_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static <K, V> Map<K, V> mapOf(Entry<K, V> ... entries) {
        return Arrays.stream(entries).collect(HashMap::new, (map, entry) -> map.put(entry.getKey(), entry.getValue()), HashMap::putAll);
    }

    public static <V> Set<V> setOf(V ... values) {
        return Arrays.stream(values).collect(Collectors.toSet());
    }

    public static <K, V> Entry<K, V> entryOf(K key, V value) {
        return Entry.of(key, value);
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V> map1, Map<K, V> map2) {
        HashMap<K, V> mergedMap = new HashMap<K, V>();
        if (map1 != null) {
            mergedMap.putAll(map1);
        }
        if (map2 != null) {
            mergedMap.putAll(map2);
        }
        return mergedMap;
    }

    public static Map<String, String> prepareParams(Map<String, String> map) {
        map.values().removeIf(Objects::isNull);
        return map;
    }

    public static String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof EnumWrapper) {
            return ((EnumWrapper)value).getStringValue();
        }
        if (value instanceof Valuable) {
            return ((Valuable)value).getValue();
        }
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty() && list.get(0) instanceof SerializableObject) {
                return JsonManager.serialize(value).toString();
            }
            return ((List)value).stream().map(UtilsManager::convertToString).collect(Collectors.joining(","));
        }
        if (value instanceof ArrayNode) {
            return UtilsManager.convertToString(new ObjectMapper().convertValue(value, List.class));
        }
        if (value instanceof JsonNode) {
            return ((JsonNode)value).asText();
        }
        if (value instanceof SerializableObject) {
            return JsonManager.serialize(value).toString();
        }
        return value.toString();
    }

    public static void writeInputStreamToOutputStream(InputStream input, OutputStream output) {
        try {
            byte[] buffer = new byte[8192];
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                input.close();
                output.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String getUuid() {
        return UUID.randomUUID().toString();
    }

    public static byte[] generateByteBuffer(int size) {
        byte[] bytes = new byte[size];
        Arrays.fill(bytes, (byte)0);
        return bytes;
    }

    public static InputStream generateByteStream(int size) {
        byte[] bytes = UtilsManager.generateByteBuffer(size);
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream generateByteStreamFromBuffer(byte[] buffer) {
        return new ByteArrayInputStream(buffer);
    }

    public static byte[] readByteStream(InputStream inputStream) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        try {
            int bytesRead;
            while ((bytesRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return buffer.toByteArray();
    }

    public static boolean bufferEquals(byte[] buffer1, byte[] buffer2) {
        return Arrays.equals(buffer1, buffer2);
    }

    public static int bufferLength(byte[] buffer) {
        return buffer.length;
    }

    public static InputStream decodeBase64ByteStream(String value) {
        return new ByteArrayInputStream(Base64.getDecoder().decode(value));
    }

    public static String decodeBase64(String value) {
        return new String(Base64.getDecoder().decode(value));
    }

    public static InputStream stringToByteStream(String value) {
        return new ByteArrayInputStream(value.getBytes());
    }

    public static OutputStream getFileOutputStream(String filePath) {
        try {
            return new FileOutputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeFileOutputStream(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readBufferFromFile(String filePath) {
        try {
            InputStream inputStream = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
            return UtilsManager.readByteStream(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getEnvVar(String envVar) {
        return System.getenv(envVar);
    }

    public static void delayInSeconds(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readTextFromFile(String filePath) {
        try {
            return new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isBrowser() {
        return false;
    }

    public static long getEpochTimeInSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String createJwtAssertion(Map<String, Object> claims, JwtKey jwtKey, JwtSignOptions jwtOptions) {
        String assertion;
        JwtClaims jwtClaims = new JwtClaims();
        jwtClaims.setIssuer(jwtOptions.getIssuer());
        jwtClaims.setAudience(jwtOptions.getAudience());
        jwtClaims.setExpirationTime(NumericDate.fromSeconds((long)((Long)claims.get("exp"))));
        jwtClaims.setSubject(jwtOptions.getSubject());
        jwtClaims.setClaim("box_sub_type", claims.get("box_sub_type"));
        jwtClaims.setGeneratedJwtId(64);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(jwtClaims.toJson());
        jws.setKey((Key)jwtOptions.privateKeyDecryptor.decryptPrivateKey(jwtKey.getKey(), jwtKey.getPassphrase()));
        jws.setAlgorithmHeaderValue(jwtOptions.getAlgorithm().getValue());
        jws.setHeader("typ", "JWT");
        if (jwtOptions.getKeyid() != null && !jwtOptions.getKeyid().isEmpty()) {
            jws.setHeader("kid", jwtOptions.getKeyid());
        }
        try {
            assertion = jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new BoxSDKError("Error serializing JSON Web Token assertion.", (Exception)((Object)e));
        }
        return assertion;
    }

    public static JsonNode getValueFromObjectRawData(SerializableObject obj, String key) {
        JsonNode value = obj.getRawData();
        for (String k : key.split("\\.")) {
            if (value == null || !value.has(k)) {
                return null;
            }
            value = value.get(k);
        }
        return value;
    }

    public static double random(double min, double max) {
        return Math.random() * (max - min) + min;
    }

    public static String hexToBase64(String hex) {
        return Base64.getEncoder().encodeToString(new BigInteger(hex, 16).toByteArray());
    }

    public static Iterator<InputStream> iterateChunks(final InputStream stream, final long chunkSize, long fileSize) {
        return new Iterator<InputStream>(){
            private boolean streamIsFinished = false;

            @Override
            public boolean hasNext() {
                return !this.streamIsFinished;
            }

            @Override
            public InputStream next() {
                try {
                    byte[] buffer = new byte[(int)chunkSize];
                    int bytesRead = 0;
                    while ((long)bytesRead < chunkSize) {
                        int read = stream.read(buffer, bytesRead, (int)(chunkSize - (long)bytesRead));
                        if (read == -1) {
                            this.streamIsFinished = true;
                            break;
                        }
                        bytesRead += read;
                    }
                    if (bytesRead == 0) {
                        this.streamIsFinished = true;
                        return null;
                    }
                    return new ByteArrayInputStream(buffer, 0, bytesRead);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error reading from stream", e);
                }
            }
        };
    }

    public static <Accumulator, T> Accumulator reduceIterator(Iterator<T> iterator, BiFunction<Accumulator, T, Accumulator> reducer, Accumulator initialValue) {
        Accumulator result = initialValue;
        while (iterator.hasNext()) {
            T item = iterator.next();
            result = reducer.apply(result, item);
        }
        return result;
    }

    public static Map<String, String> sanitizeMap(Map<String, String> dictionary, Map<String, String> keysToSanitize) {
        return dictionary.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> keysToSanitize.containsKey(((String)entry.getKey()).toLowerCase(Locale.ROOT)) ? JsonManager.sanitizedValue() : (String)entry.getValue()));
    }

    public static OffsetDateTime dateTimeFromString(String dateString) {
        DateTimeFormatter[] formatters;
        for (DateTimeFormatter formatter : formatters = new DateTimeFormatter[]{OFFSET_DATE_TIME_FORMAT, OFFSET_DATE_TIME_FORMAT_WITH_MILLIS, OFFSET_DATE_TIME_FORMAT_WITH_MICROS}) {
            try {
                return OffsetDateTime.parse(dateString, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public static String dateTimeToString(OffsetDateTime dateTime) {
        return dateTime.format(OFFSET_DATE_TIME_FORMAT_WITH_MILLIS);
    }

    public static OffsetDateTime dateFromString(String dateString) {
        try {
            DateTimeFormatter[] formatters;
            if (dateString.matches("\\d{4}-\\d{2}-\\d{2}")) {
                return OffsetDateTime.parse(dateString + "T00:00:00Z");
            }
            for (DateTimeFormatter formatter : formatters = new DateTimeFormatter[]{OFFSET_DATE_TIME_FORMAT, OFFSET_DATE_TIME_FORMAT_WITH_MILLIS, OFFSET_DATE_TIME_FORMAT_WITH_MICROS}) {
                try {
                    return OffsetDateTime.parse(dateString, formatter);
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
            return null;
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public static String dateToString(OffsetDateTime date) {
        return date.format(OFFSET_DATE_FORMAT);
    }

    public static String escapeUnicode(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch >= '\u007f') {
                result.append(String.format("\\u%04x", ch));
                continue;
            }
            if (ch == '\\') {
                result.append("\\\\");
                continue;
            }
            if (ch == '\n') {
                result.append("\\n");
                continue;
            }
            if (ch == '\r') {
                result.append("\\r");
                continue;
            }
            if (ch == '\t') {
                result.append("\\t");
                continue;
            }
            if (ch == '/') {
                if (i == 0 || value.charAt(i - 1) != '\\') {
                    result.append("\\/");
                    continue;
                }
                result.append(ch);
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static OffsetDateTime epochSecondsToDateTime(long seconds) {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(seconds), ZoneOffset.UTC);
    }

    public static long dateTimeToEpochSeconds(OffsetDateTime dateTime) {
        return dateTime.toEpochSecond();
    }

    public static boolean compareSignatures(String expectedSignature, String receivedSignature) {
        if (expectedSignature == null || receivedSignature == null) {
            return false;
        }
        byte[] expectedBytes = expectedSignature.getBytes(StandardCharsets.UTF_8);
        byte[] receivedBytes = receivedSignature.getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(expectedBytes, receivedBytes);
    }

    public static String computeWebhookSignature(String body, Map<String, String> headers, String signatureKey, boolean escapeBody) {
        if (signatureKey == null) {
            return null;
        }
        if (!"1".equals(headers.get("box-signature-version"))) {
            return null;
        }
        if (!"HmacSHA256".equals(headers.get("box-signature-algorithm"))) {
            return null;
        }
        if (!headers.containsKey("box-delivery-timestamp")) {
            return null;
        }
        try {
            String escapedBody = escapeBody ? UtilsManager.escapeUnicode(body) : body;
            byte[] encodedSignatureKey = signatureKey.getBytes("UTF-8");
            byte[] encodedBody = escapedBody.getBytes("UTF-8");
            byte[] encodedTimestamp = headers.get("box-delivery-timestamp").getBytes("UTF-8");
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(encodedSignatureKey, "HmacSHA256");
            mac.init(secretKeySpec);
            mac.update(encodedBody);
            mac.update(encodedTimestamp);
            byte[] hmacDigest = mac.doFinal();
            return Base64.getEncoder().encodeToString(hmacDigest);
        }
        catch (Exception e) {
            return null;
        }
    }
}

