/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.devicepinners;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.devicepinners.DeleteDevicePinnerByIdHeaders;
import com.box.sdkgen.managers.devicepinners.GetDevicePinnerByIdHeaders;
import com.box.sdkgen.managers.devicepinners.GetEnterpriseDevicePinnersHeaders;
import com.box.sdkgen.managers.devicepinners.GetEnterpriseDevicePinnersQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.devicepinner.DevicePinner;
import com.box.sdkgen.schemas.devicepinners.DevicePinners;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class DevicePinnersManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public DevicePinnersManager() {
        this.networkSession = new NetworkSession();
    }

    protected DevicePinnersManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public DevicePinner getDevicePinnerById(String devicePinnerId) {
        return this.getDevicePinnerById(devicePinnerId, new GetDevicePinnerByIdHeaders());
    }

    public DevicePinner getDevicePinnerById(String devicePinnerId, GetDevicePinnerByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/device_pinners/", UtilsManager.convertToString(devicePinnerId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), DevicePinner.class);
    }

    public void deleteDevicePinnerById(String devicePinnerId) {
        this.deleteDevicePinnerById(devicePinnerId, new DeleteDevicePinnerByIdHeaders());
    }

    public void deleteDevicePinnerById(String devicePinnerId, DeleteDevicePinnerByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/device_pinners/", UtilsManager.convertToString(devicePinnerId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public DevicePinners getEnterpriseDevicePinners(String enterpriseId) {
        return this.getEnterpriseDevicePinners(enterpriseId, new GetEnterpriseDevicePinnersQueryParams(), new GetEnterpriseDevicePinnersHeaders());
    }

    public DevicePinners getEnterpriseDevicePinners(String enterpriseId, GetEnterpriseDevicePinnersQueryParams queryParams) {
        return this.getEnterpriseDevicePinners(enterpriseId, queryParams, new GetEnterpriseDevicePinnersHeaders());
    }

    public DevicePinners getEnterpriseDevicePinners(String enterpriseId, GetEnterpriseDevicePinnersHeaders headers) {
        return this.getEnterpriseDevicePinners(enterpriseId, new GetEnterpriseDevicePinnersQueryParams(), headers);
    }

    public DevicePinners getEnterpriseDevicePinners(String enterpriseId, GetEnterpriseDevicePinnersQueryParams queryParams, GetEnterpriseDevicePinnersHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("direction", UtilsManager.convertToString(queryParams.getDirection()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/enterprises/", UtilsManager.convertToString(enterpriseId), "/device_pinners"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), DevicePinners.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public DevicePinnersManager build() {
            return new DevicePinnersManager(this);
        }
    }
}

