/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.docgentemplate;

import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.docgentemplate.CreateDocgenTemplateV2025R0Headers;
import com.box.sdkgen.managers.docgentemplate.DeleteDocgenTemplateByIdV2025R0Headers;
import com.box.sdkgen.managers.docgentemplate.GetDocgenTemplateByIdV2025R0Headers;
import com.box.sdkgen.managers.docgentemplate.GetDocgenTemplateJobByIdV2025R0Headers;
import com.box.sdkgen.managers.docgentemplate.GetDocgenTemplateJobByIdV2025R0QueryParams;
import com.box.sdkgen.managers.docgentemplate.GetDocgenTemplateTagsV2025R0Headers;
import com.box.sdkgen.managers.docgentemplate.GetDocgenTemplateTagsV2025R0QueryParams;
import com.box.sdkgen.managers.docgentemplate.GetDocgenTemplatesV2025R0Headers;
import com.box.sdkgen.managers.docgentemplate.GetDocgenTemplatesV2025R0QueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.v2025r0.docgenjobsv2025r0.DocGenJobsV2025R0;
import com.box.sdkgen.schemas.v2025r0.docgentagsv2025r0.DocGenTagsV2025R0;
import com.box.sdkgen.schemas.v2025r0.docgentemplatebasev2025r0.DocGenTemplateBaseV2025R0;
import com.box.sdkgen.schemas.v2025r0.docgentemplatecreaterequestv2025r0.DocGenTemplateCreateRequestV2025R0;
import com.box.sdkgen.schemas.v2025r0.docgentemplatesv2025r0.DocGenTemplatesV2025R0;
import com.box.sdkgen.schemas.v2025r0.docgentemplatev2025r0.DocGenTemplateV2025R0;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class DocgenTemplateManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public DocgenTemplateManager() {
        this.networkSession = new NetworkSession();
    }

    protected DocgenTemplateManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public DocGenTemplateBaseV2025R0 createDocgenTemplateV2025R0(DocGenTemplateCreateRequestV2025R0 requestBody) {
        return this.createDocgenTemplateV2025R0(requestBody, new CreateDocgenTemplateV2025R0Headers());
    }

    public DocGenTemplateBaseV2025R0 createDocgenTemplateV2025R0(DocGenTemplateCreateRequestV2025R0 requestBody, CreateDocgenTemplateV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/docgen_templates"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), DocGenTemplateBaseV2025R0.class);
    }

    public DocGenTemplatesV2025R0 getDocgenTemplatesV2025R0() {
        return this.getDocgenTemplatesV2025R0(new GetDocgenTemplatesV2025R0QueryParams(), new GetDocgenTemplatesV2025R0Headers());
    }

    public DocGenTemplatesV2025R0 getDocgenTemplatesV2025R0(GetDocgenTemplatesV2025R0QueryParams queryParams) {
        return this.getDocgenTemplatesV2025R0(queryParams, new GetDocgenTemplatesV2025R0Headers());
    }

    public DocGenTemplatesV2025R0 getDocgenTemplatesV2025R0(GetDocgenTemplatesV2025R0Headers headers) {
        return this.getDocgenTemplatesV2025R0(new GetDocgenTemplatesV2025R0QueryParams(), headers);
    }

    public DocGenTemplatesV2025R0 getDocgenTemplatesV2025R0(GetDocgenTemplatesV2025R0QueryParams queryParams, GetDocgenTemplatesV2025R0Headers headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/docgen_templates"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), DocGenTemplatesV2025R0.class);
    }

    public void deleteDocgenTemplateByIdV2025R0(String templateId) {
        this.deleteDocgenTemplateByIdV2025R0(templateId, new DeleteDocgenTemplateByIdV2025R0Headers());
    }

    public void deleteDocgenTemplateByIdV2025R0(String templateId, DeleteDocgenTemplateByIdV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/docgen_templates/", UtilsManager.convertToString(templateId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public DocGenTemplateV2025R0 getDocgenTemplateByIdV2025R0(String templateId) {
        return this.getDocgenTemplateByIdV2025R0(templateId, new GetDocgenTemplateByIdV2025R0Headers());
    }

    public DocGenTemplateV2025R0 getDocgenTemplateByIdV2025R0(String templateId, GetDocgenTemplateByIdV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/docgen_templates/", UtilsManager.convertToString(templateId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), DocGenTemplateV2025R0.class);
    }

    public DocGenTagsV2025R0 getDocgenTemplateTagsV2025R0(String templateId) {
        return this.getDocgenTemplateTagsV2025R0(templateId, new GetDocgenTemplateTagsV2025R0QueryParams(), new GetDocgenTemplateTagsV2025R0Headers());
    }

    public DocGenTagsV2025R0 getDocgenTemplateTagsV2025R0(String templateId, GetDocgenTemplateTagsV2025R0QueryParams queryParams) {
        return this.getDocgenTemplateTagsV2025R0(templateId, queryParams, new GetDocgenTemplateTagsV2025R0Headers());
    }

    public DocGenTagsV2025R0 getDocgenTemplateTagsV2025R0(String templateId, GetDocgenTemplateTagsV2025R0Headers headers) {
        return this.getDocgenTemplateTagsV2025R0(templateId, new GetDocgenTemplateTagsV2025R0QueryParams(), headers);
    }

    public DocGenTagsV2025R0 getDocgenTemplateTagsV2025R0(String templateId, GetDocgenTemplateTagsV2025R0QueryParams queryParams, GetDocgenTemplateTagsV2025R0Headers headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("template_version_id", UtilsManager.convertToString(queryParams.getTemplateVersionId())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/docgen_templates/", UtilsManager.convertToString(templateId), "/tags"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), DocGenTagsV2025R0.class);
    }

    public DocGenJobsV2025R0 getDocgenTemplateJobByIdV2025R0(String templateId) {
        return this.getDocgenTemplateJobByIdV2025R0(templateId, new GetDocgenTemplateJobByIdV2025R0QueryParams(), new GetDocgenTemplateJobByIdV2025R0Headers());
    }

    public DocGenJobsV2025R0 getDocgenTemplateJobByIdV2025R0(String templateId, GetDocgenTemplateJobByIdV2025R0QueryParams queryParams) {
        return this.getDocgenTemplateJobByIdV2025R0(templateId, queryParams, new GetDocgenTemplateJobByIdV2025R0Headers());
    }

    public DocGenJobsV2025R0 getDocgenTemplateJobByIdV2025R0(String templateId, GetDocgenTemplateJobByIdV2025R0Headers headers) {
        return this.getDocgenTemplateJobByIdV2025R0(templateId, new GetDocgenTemplateJobByIdV2025R0QueryParams(), headers);
    }

    public DocGenJobsV2025R0 getDocgenTemplateJobByIdV2025R0(String templateId, GetDocgenTemplateJobByIdV2025R0QueryParams queryParams, GetDocgenTemplateJobByIdV2025R0Headers headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/docgen_template_jobs/", UtilsManager.convertToString(templateId)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), DocGenJobsV2025R0.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public DocgenTemplateManager build() {
            return new DocgenTemplateManager(this);
        }
    }
}

